/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.el.impl;

import de.odysseus.el.util.SimpleResolver;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.FunctionMapper;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import org.bridje.el.ModelResolver;
import org.bridje.ioc.IocContext;

class IocElContext
extends ELContext {
    private static Map<String, Class<?>> MODELS;
    private final ExpressionFactory factory;
    private Functions functions;
    private Variables variables;
    private ELResolver resolver;
    private final IocContext context;

    private static Map<String, Class<?>> getModels(IocContext<?> ctx) {
        if (MODELS == null) {
            IocElContext.initModels(ctx);
        }
        return MODELS;
    }

    private static synchronized void initModels(IocContext<?> ctx) {
        if (MODELS == null) {
            HashMap result = new HashMap();
            ModelResolver resolver = (ModelResolver)ctx.find(ModelResolver.class);
            if (resolver != null) {
                resolver.resolveAllModels(ctx, result);
            }
            MODELS = result;
        }
    }

    public IocElContext(IocContext context, ExpressionFactory factory) {
        this.context = context;
        this.factory = factory;
    }

    public void setFunction(String prefix, String localName, Method method) {
        if (this.functions == null) {
            this.functions = new Functions(this.factory);
        }
        this.functions.setFunction(prefix, localName, method);
    }

    public ValueExpression setVariable(String name, ValueExpression expression) {
        if (this.variables == null) {
            this.variables = new Variables(this.context, this.factory);
        }
        return this.variables.setVariable(name, expression);
    }

    public FunctionMapper getFunctionMapper() {
        if (this.functions == null) {
            this.functions = new Functions(this.factory);
        }
        return this.functions;
    }

    public VariableMapper getVariableMapper() {
        if (this.variables == null) {
            this.variables = new Variables(this.context, this.factory);
        }
        return this.variables;
    }

    public ELResolver getELResolver() {
        if (this.resolver == null) {
            CompositeELResolver cr = new CompositeELResolver();
            cr.add((ELResolver)new CompositeELResolver());
            cr.add((ELResolver)new ResourceBundleELResolver());
            cr.add((ELResolver)new MapELResolver(false));
            cr.add((ELResolver)new SimpleResolver());
            this.resolver = cr;
        }
        return this.resolver;
    }

    public void setELResolver(ELResolver resolver) {
        this.resolver = resolver;
    }

    static class Variables
    extends VariableMapper {
        private final ExpressionFactory factory;
        private final Map<String, ValueExpression> map = new HashMap<String, ValueExpression>();
        private final IocContext<?> context;

        public Variables(IocContext<?> context, ExpressionFactory factory) {
            this.context = context;
            this.factory = factory;
        }

        public ValueExpression resolveVariable(String variable) {
            Map models;
            if (!this.map.containsKey(variable) && (models = IocElContext.getModels(this.context)).containsKey(variable)) {
                Class compCls = (Class)models.get(variable);
                Object comp = this.context.find(compCls);
                ValueExpression ve = this.factory.createValueExpression(comp, compCls);
                this.map.put(variable, ve);
            }
            return this.map.get(variable);
        }

        public ValueExpression setVariable(String variable, ValueExpression expression) {
            if (expression == null) {
                this.map.put(variable, null);
                return null;
            }
            return this.map.put(variable, expression);
        }
    }

    static class Functions
    extends FunctionMapper {
        private final ExpressionFactory factory;
        private Map<String, Method> map = Collections.emptyMap();

        public Functions(ExpressionFactory factory) {
            this.factory = factory;
        }

        public Method resolveFunction(String prefix, String localName) {
            return this.map.get(prefix + ":" + localName);
        }

        public void setFunction(String prefix, String localName, Method method) {
            if (this.map.isEmpty()) {
                this.map = new HashMap<String, Method>();
            }
            this.map.put(prefix + ":" + localName, method);
        }
    }
}

