/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.el.impl.convert;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bridje.el.ElAdvanceConverter;
import org.bridje.ioc.Component;
import org.bridje.ioc.Priority;

@Component
@Priority(value=5010)
class StringConverter
implements ElAdvanceConverter {
    private static final Logger LOG = Logger.getLogger(StringConverter.class.getName());

    StringConverter() {
    }

    @Override
    public <F, T> boolean canConvert(Class<F> from, Class<T> to) {
        return from == String.class && this.hasFromStringMethod(to) || to == String.class && this.hasFromStringMethod(from);
    }

    @Override
    public <T> T convert(Object value, Class<T> type) {
        if (type == String.class) {
            return (T)this.toString(value);
        }
        return this.fromString((String)value, type);
    }

    private boolean hasFromStringMethod(Class<?> cls) {
        try {
            Method method = cls.getDeclaredMethod("fromString", String.class);
            return method != null && method.getReturnType() == cls && Modifier.isStatic(method.getModifiers());
        }
        catch (NoSuchMethodException | SecurityException ex) {
            return false;
        }
    }

    private String toString(Object value) {
        return value.toString();
    }

    private <T> T fromString(String value, Class<T> type) {
        try {
            Method method = type.getMethod("fromString", String.class);
            return (T)method.invoke(null, value);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
            LOG.log(Level.SEVERE, ex.getMessage(), ex);
            return null;
        }
    }
}

