/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.el.impl;

import de.odysseus.el.misc.TypeConverter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.PostConstruct;
import javax.el.ELException;
import org.bridje.el.ElAdvanceConverter;
import org.bridje.el.ElSimpleConvertMap;
import org.bridje.el.ElSimpleConvertProvider;
import org.bridje.el.ElSimpleConverter;
import org.bridje.ioc.Component;
import org.bridje.ioc.Inject;

@Component
class TypeConverterImpl
implements TypeConverter {
    @Inject
    private ElAdvanceConverter[] advanceConverters;
    @Inject
    private ElSimpleConvertProvider[] simpleConverters;
    private Map<Class<?>, Map<Class<?>, ElAdvanceConverter>> advanceConvertMap;
    private ElSimpleConvertMap simpleConverMap;

    TypeConverterImpl() {
    }

    @PostConstruct
    public void init() {
        this.advanceConvertMap = new ConcurrentHashMap();
        this.simpleConverMap = new ElSimpleConvertMap();
        for (ElSimpleConvertProvider providers : this.simpleConverters) {
            ElSimpleConvertMap convMap = providers.createConvertMap();
            this.simpleConverMap.addAll(convMap);
        }
    }

    public <T> T convert(Object value, Class<T> type) throws ELException {
        ElAdvanceConverter converter;
        if (value == null) {
            return null;
        }
        if (type == value.getClass()) {
            return (T)value;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        ElSimpleConverter<?, T> simpleConv = this.simpleConverMap.get(value.getClass(), type);
        if (simpleConv != null) {
            return simpleConv.convert(value);
        }
        Map<Class<?>, ElAdvanceConverter> map = this.advanceConvertMap.get(value.getClass());
        if (map != null && (converter = map.get(type)) != null) {
            return converter.convert(value, type);
        }
        for (ElAdvanceConverter typeConverter : this.advanceConverters) {
            if (!typeConverter.canConvert(value.getClass(), type)) continue;
            map = this.advanceConvertMap.get(value.getClass());
            if (map == null) {
                map = new ConcurrentHashMap();
                this.advanceConvertMap.put(value.getClass(), map);
            }
            map.put(type, typeConverter);
            return typeConverter.convert(value, type);
        }
        return (T)TypeConverter.DEFAULT.convert(value, type);
    }
}

