/*
 * Decompiled with CFR 0.152.
 */
package org.bridje.el.impl;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import org.bridje.el.ElEnvironment;
import org.bridje.el.impl.ExpressionFactoryImpl;
import org.bridje.el.impl.IocElContext;
import org.bridje.ioc.Ioc;
import org.bridje.ioc.IocContext;

class IocEnviromentImpl
implements ElEnvironment {
    private static final Logger LOG = Logger.getLogger(IocEnviromentImpl.class.getName());
    private final IocElContext context;
    private final ExpressionFactory factory = (ExpressionFactory)Ioc.context().find(ExpressionFactoryImpl.class);

    public IocEnviromentImpl(IocContext context) {
        this.context = new IocElContext(context, this.factory);
    }

    @Override
    public <T> T get(String expression, Class<T> resultCls) {
        ValueExpression valueExp = this.factory.createValueExpression((ELContext)this.context, expression, resultCls);
        return (T)valueExp.getValue((ELContext)this.context);
    }

    @Override
    public <T> void set(String expression, T value) {
        Class cls = Object.class;
        if (value != null) {
            cls = value.getClass();
        }
        ValueExpression valueExp = this.factory.createValueExpression((ELContext)this.context, expression, cls);
        try {
            valueExp.setValue((ELContext)this.context, value);
        }
        catch (PropertyNotFoundException e) {
            LOG.log(Level.WARNING, e.getMessage());
        }
    }

    @Override
    public <T> void setVar(String name, T value) {
        if (value == null) {
            this.context.setVariable(name, null);
        } else {
            this.context.setVariable(name, this.factory.createValueExpression(value, value.getClass()));
        }
    }

    @Override
    public void removeVar(String name) {
        this.context.setVariable(name, null);
    }

    @Override
    public <T> T getVar(String name, Class<T> resultCls) {
        return this.get("${" + name + "}", resultCls);
    }

    @Override
    public String getVarAsString(String name) {
        return this.get("${" + name + "}", String.class);
    }
}

