/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.file.orthoxml;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.modelmbean.XMLParseException;
import javax.xml.stream.XMLStreamException;
import org.bridgedb.BridgeDb;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperCapabilities;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.bio.BioDataSource;
import org.bridgedb.impl.InternalUtils;
import sbc.orthoxml.Database;
import sbc.orthoxml.Gene;
import sbc.orthoxml.Group;
import sbc.orthoxml.Species;
import sbc.orthoxml.io.OrthoXMLReader;

public class IDMapperOrthoXml
implements IDMapper {
    private Map<Xref, Set<Xref>> allIds = new HashMap<Xref, Set<Xref>>();
    private Set<DataSource> dataSources = new HashSet<DataSource>();
    private static Map<String, DataSource> aliases;
    private boolean connected = true;

    private static Reader getReader(URL url) throws IDMapperException {
        try {
            InputStream inputStream = InternalUtils.getInputStream((URL)url);
            return new InputStreamReader(inputStream);
        }
        catch (IOException e) {
            throw new IDMapperException((Throwable)e);
        }
    }

    private void readMappings(Reader in) throws FileNotFoundException, XMLStreamException, XMLParseException {
        Group group;
        OrthoXMLReader reader = new OrthoXMLReader(in);
        for (Species species : reader.getSpecies()) {
            System.out.printf(species.getName() + "\t", new Object[0]);
            System.out.printf(species.getNcbiTaxId() + "\t", new Object[0]);
        }
        System.out.printf("#", new Object[0]);
        while ((group = reader.next()) != null) {
            HashSet<Xref> groupRefs = new HashSet<Xref>();
            for (Gene gene : group.getNestedGenes()) {
                Database database = gene.getDatabase();
                DataSource ds = aliases.get(database.getName());
                if (ds == null) {
                    ds = DataSource.getByFullName((String)database.getName());
                }
                this.dataSources.add(ds);
                groupRefs.add(new Xref(gene.getGeneIdentifier(), ds));
                groupRefs.add(new Xref(gene.getProteinIdentifier(), ds));
            }
            for (Xref ref : groupRefs) {
                this.allIds.put(ref, groupRefs);
            }
        }
    }

    public IDMapperOrthoXml(Reader reader) throws IDMapperException {
        try {
            this.readMappings(reader);
        }
        catch (IOException e) {
            throw new IDMapperException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new IDMapperException((Throwable)e);
        }
        catch (XMLParseException e) {
            throw new IDMapperException((Throwable)e);
        }
    }

    public Map<Xref, Set<Xref>> mapID(Collection<Xref> srcXrefs, DataSource ... tgtDataSources) throws IDMapperException {
        Map result = InternalUtils.mapMultiFromSingle((IDMapper)this, srcXrefs, (DataSource[])tgtDataSources);
        return result;
    }

    public Set<Xref> mapID(Xref ref, DataSource ... tgtDataSources) throws IDMapperException {
        HashSet<Xref> result = new HashSet<Xref>();
        if (tgtDataSources.length == 0) {
            Set<Xref> toAdd = this.allIds.get(ref);
            if (toAdd != null) {
                result.addAll(toAdd);
            }
        } else {
            HashSet<DataSource> filter = new HashSet<DataSource>();
            for (DataSource ds : tgtDataSources) {
                filter.add(ds);
            }
            if (this.allIds.containsKey(ref)) {
                for (Xref dest : this.allIds.get(ref)) {
                    if (!filter.contains(dest.getDataSource())) continue;
                    result.add(dest);
                }
            }
        }
        return result;
    }

    public boolean xrefExists(Xref xref) throws IDMapperException {
        return this.allIds.containsKey(xref);
    }

    public Set<Xref> freeSearch(String text, int limit) throws IDMapperException {
        throw new UnsupportedOperationException();
    }

    public IDMapperCapabilities getCapabilities() {
        return new Capabilities();
    }

    public void close() throws IDMapperException {
        this.connected = false;
    }

    public boolean isConnected() {
        return this.connected;
    }

    static {
        BridgeDb.register((String)"idmapper-orthoxml", (org.bridgedb.Driver)new Driver());
        aliases = new HashMap<String, DataSource>();
        aliases.put("FlyBase", BioDataSource.FLYBASE);
        aliases.put("Ensembl", BioDataSource.ENSEMBL_HUMAN);
    }

    private class Capabilities
    implements IDMapperCapabilities {
        private Capabilities() {
        }

        public boolean isFreeSearchSupported() {
            return false;
        }

        public Set<DataSource> getSupportedSrcDataSources() throws IDMapperException {
            return IDMapperOrthoXml.this.dataSources;
        }

        public Set<DataSource> getSupportedTgtDataSources() throws IDMapperException {
            return IDMapperOrthoXml.this.dataSources;
        }

        public boolean isMappingSupported(DataSource src, DataSource tgt) throws IDMapperException {
            return IDMapperOrthoXml.this.dataSources.contains(src) && IDMapperOrthoXml.this.dataSources.contains(tgt);
        }

        public String getProperty(String key) {
            return null;
        }

        public Set<String> getKeys() {
            return Collections.emptySet();
        }
    }

    private static final class Driver
    implements org.bridgedb.Driver {
        private Driver() {
        }

        public IDMapper connect(String locationString) throws IDMapperException {
            Reader reader;
            try {
                reader = IDMapperOrthoXml.getReader(new URL(locationString));
            }
            catch (MalformedURLException e) {
                throw new IDMapperException((Throwable)e);
            }
            return new IDMapperOrthoXml(reader);
        }
    }
}

