/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.util;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.util.HttpUtil;

public class OpenIdConsumer {
    private static final Log LOG = LogFactory.getLog(OpenIdConsumer.class);
    private static Map<String, String> associationMap = new HashMap<String, String>();
    private static Map<String, String> requestTokenMap;
    public static final String OPENID_REQUEST_TOKEN = "openid.ext2.request_token";

    static {
        associationMap.put("openid.ns", "http://specs.openid.net/auth/2.0");
        associationMap.put("openid.mode", "associate");
        associationMap.put("openid.assoc_type", "HMAC-SHA1");
        associationMap.put("openid.session_type", "no-encryption");
        requestTokenMap = new HashMap<String, String>();
        requestTokenMap.put("openid.ns", "http://specs.openid.net/auth/2.0");
        requestTokenMap.put("openid.claimed_id", "http://specs.openid.net/auth/2.0/identifier_select");
        requestTokenMap.put("openid.identity", "http://specs.openid.net/auth/2.0/identifier_select");
        requestTokenMap.put("openid.mode", "checkid_setup");
        requestTokenMap.put("openid.ns.pape", "http://specs.openid.net/extensions/pape/1.0");
        requestTokenMap.put("openid.ns.max_auth_age", "0");
        requestTokenMap.put("openid.ns.ax", "http://openid.net/srv/ax/1.0");
        requestTokenMap.put("openid.ax.mode", "fetch_request");
        requestTokenMap.put("openid.ax.type.country", "http://axschema.org/contact/country/home");
        requestTokenMap.put("openid.ax.type.email", "http://axschema.org/contact/email");
        requestTokenMap.put("openid.ax.type.firstname", "http://axschema.org/namePerson/first");
        requestTokenMap.put("openid.ax.type.language", "http://axschema.org/pref/language");
        requestTokenMap.put("openid.ax.type.lastname", "http://axschema.org/namePerson/last");
        requestTokenMap.put("openid.ax.required", "country,email,firstname,language,lastname");
        requestTokenMap.put("openid.ns.ext2", "http://specs.openid.net/extensions/oauth/1.0");
    }

    public static String getAssociationURL(String url) throws Exception {
        String param = HttpUtil.buildParams(associationMap);
        char separator = url.indexOf(63) == -1 ? (char)'?' : '&';
        return String.valueOf(url) + separator + param;
    }

    public static String getRequestTokenURL(String requestTokenUrl, String returnTo, String realm, String assocHandle, String consumerURL, String scope) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.putAll(requestTokenMap);
        params.put("openid.return_to", returnTo);
        params.put("openid.realm", realm);
        params.put("openid.assoc_handle", assocHandle);
        params.put("openid.ext2.consumer", consumerURL);
        if (scope != null) {
            params.put("openid.ext2.scope", scope);
        }
        String paramStr = HttpUtil.buildParams(params);
        char separator = requestTokenUrl.indexOf(63) == -1 ? (char)'?' : '&';
        String url = String.valueOf(requestTokenUrl) + separator + paramStr;
        LOG.debug((Object)("Request Token URL : " + url));
        return url;
    }

    public static Profile getUserInfo(Map<String, String> requestParams) {
        Profile p = new Profile();
        p.setEmail(requestParams.get("openid.ext1.value.email"));
        p.setFirstName(requestParams.get("openid.ext1.value.firstname"));
        p.setLastName(requestParams.get("openid.ext1.value.lastname"));
        p.setCountry(requestParams.get("openid.ext1.value.country"));
        p.setLanguage(requestParams.get("openid.ext1.value.language"));
        p.setValidatedId(requestParams.get("openid.identity"));
        return p;
    }
}

