/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.plugin.googleplus;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Album;
import org.brickred.socialauth.Photo;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.plugin.AlbumsPlugin;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.ProviderSupport;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.XMLParseUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AlbumsPluginImpl
implements AlbumsPlugin,
Serializable {
    private static final long serialVersionUID = 1408925565059390624L;
    private static final String ALBUMS_URL = "https://picasaweb.google.com/data/feed/api/user/default";
    private static final String PHOTOS_URL = "https://picasaweb.google.com/data/feed/api/user/default/albumid/";
    private static final String ALBUM_NAMESPACE = "http://schemas.google.com/photos/2007";
    private static final String MEDIA_NAMESPACE = "http://search.yahoo.com/mrss/";
    private final Log LOG = LogFactory.getLog(this.getClass());
    private ProviderSupport providerSupport;

    public AlbumsPluginImpl(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }

    @Override
    public List<Album> getAlbums() throws Exception {
        Element root;
        Response response = this.providerSupport.api(ALBUMS_URL, MethodType.GET.toString(), null, null, null);
        try {
            root = XMLParseUtil.loadXmlResource(response.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the albums from response.https://picasaweb.google.com/data/feed/api/user/default", e);
        }
        ArrayList<Album> albums = new ArrayList<Album>();
        if (root != null) {
            NodeList albumList = root.getElementsByTagName("entry");
            if (albumList != null && albumList.getLength() > 0) {
                this.LOG.info((Object)("Found albums : " + albumList.getLength()));
                int i = 0;
                while (i < albumList.getLength()) {
                    Element tl;
                    NodeList thumbnail;
                    Element el;
                    Album album = new Album();
                    Element p = (Element)albumList.item(i);
                    NodeList id = p.getElementsByTagNameNS(ALBUM_NAMESPACE, "id");
                    String albumId = XMLParseUtil.getElementData(id.item(0));
                    album.setId(albumId);
                    album.setName(XMLParseUtil.getElementData(p, "title"));
                    NodeList count = p.getElementsByTagNameNS(ALBUM_NAMESPACE, "numphotos");
                    album.setPhotosCount(Integer.parseInt(XMLParseUtil.getElementData(count.item(0))));
                    NodeList mediaGroup = p.getElementsByTagNameNS(MEDIA_NAMESPACE, "group");
                    String url = null;
                    if (mediaGroup != null && mediaGroup.getLength() > 0 && (el = (Element)mediaGroup.item(0)) != null && (thumbnail = el.getElementsByTagNameNS(MEDIA_NAMESPACE, "thumbnail")) != null && (tl = (Element)thumbnail.item(0)) != null) {
                        url = tl.getAttribute("url");
                    }
                    album.setCoverPhoto(url);
                    String rel = null;
                    String href = null;
                    NodeList link = p.getElementsByTagName("link");
                    if (link != null && link.getLength() > 0) {
                        int j = 0;
                        while (j < link.getLength()) {
                            Element l = (Element)link.item(j);
                            if (l != null && (rel = l.getAttribute("rel")) != null && rel.equalsIgnoreCase("alternate")) {
                                href = l.getAttribute("href");
                            }
                            ++j;
                        }
                    }
                    album.setLink(href);
                    List<Photo> photos = this.getAlbumPhotos(albumId);
                    album.setPhotos(photos);
                    albums.add(album);
                    System.out.println(album);
                    ++i;
                }
            } else {
                this.LOG.info((Object)"No albums were obtained from : https://picasaweb.google.com/data/feed/api/user/default");
            }
        }
        return albums;
    }

    private List<Photo> getAlbumPhotos(String id) throws Exception {
        Element root;
        Response response = this.providerSupport.api(PHOTOS_URL + id, MethodType.GET.toString(), null, null, null);
        this.LOG.info((Object)("Getting Photos of Album :: " + id));
        try {
            root = XMLParseUtil.loadXmlResource(response.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the photos from response.https://picasaweb.google.com/data/feed/api/user/default/albumid/" + id, e);
        }
        ArrayList<Photo> photos = new ArrayList<Photo>();
        if (root != null) {
            NodeList photoList = root.getElementsByTagName("entry");
            if (photoList != null && photoList.getLength() > 0) {
                this.LOG.info((Object)("Found photos : " + photoList.getLength()));
                int i = 0;
                while (i < photoList.getLength()) {
                    Element el;
                    Photo photo = new Photo();
                    Element pl = (Element)photoList.item(i);
                    NodeList pid = pl.getElementsByTagNameNS(ALBUM_NAMESPACE, "id");
                    String photoId = XMLParseUtil.getElementData(pid.item(0));
                    photo.setId(photoId);
                    photo.setTitle(XMLParseUtil.getElementData(pl, "title"));
                    NodeList mediaGroup = pl.getElementsByTagNameNS(MEDIA_NAMESPACE, "group");
                    String urlLarge = null;
                    String urlMedium = null;
                    String urlSmall = null;
                    String urlThumb = null;
                    int width = 0;
                    if (mediaGroup != null && mediaGroup.getLength() > 0 && (el = (Element)mediaGroup.item(0)) != null) {
                        NodeList thumbnail;
                        Element cl;
                        NodeList content = el.getElementsByTagNameNS(MEDIA_NAMESPACE, "content");
                        if (content != null && (cl = (Element)content.item(0)) != null) {
                            urlLarge = cl.getAttribute("url");
                        }
                        if ((thumbnail = el.getElementsByTagNameNS(MEDIA_NAMESPACE, "thumbnail")) != null && thumbnail.getLength() > 0) {
                            int k = 0;
                            while (k < thumbnail.getLength()) {
                                Element thumb = (Element)thumbnail.item(k);
                                if (thumb != null) {
                                    width = Integer.parseInt(thumb.getAttribute("width"));
                                    if (width == 288) {
                                        urlMedium = thumb.getAttribute("url");
                                    } else if (width == 144) {
                                        urlSmall = thumb.getAttribute("url");
                                    } else if (width == 72) {
                                        urlThumb = thumb.getAttribute("url");
                                    }
                                }
                                ++k;
                            }
                        }
                    }
                    photo.setLargeImage(urlLarge);
                    photo.setMediumImage(urlMedium);
                    photo.setSmallImage(urlSmall);
                    photo.setThumbImage(urlThumb);
                    photos.add(photo);
                    ++i;
                }
            } else {
                this.LOG.info((Object)"No photos were obtained from : https://picasaweb.google.com/data/feed/api/user/default/albumid/");
            }
        }
        return photos;
    }

    @Override
    public ProviderSupport getProviderSupport() {
        return this.providerSupport;
    }

    @Override
    public void setProviderSupport(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }
}

