/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.plugin.flickr;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Album;
import org.brickred.socialauth.Photo;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.plugin.AlbumsPlugin;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.ProviderSupport;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.XMLParseUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class AlbumsPluginImpl
implements AlbumsPlugin,
Serializable {
    private static final long serialVersionUID = 5350785649768508189L;
    private static final String ALBUMS_URL = "https://api.flickr.com/services/rest/?method=flickr.photosets.getList&api_key=%1$s&primary_photo_extras=url_m";
    private static final String ALBUM_PHOTOS_URL = "https://api.flickr.com/services/rest/?method=flickr.photosets.getPhotos&photoset_id=%1$s&extras=url_t,url_s,url_m,url_o&api_key=%2$s";
    private static final String PROFILE_URL = "https://api.flickr.com/services/rest/?method=flickr.urls.getUserProfile&api_key=%1$s";
    private static final String PHOTO_LINK = "https://www.flickr.com/photos/%1$s/%2$s";
    private static final String SET_LINK = "https://www.flickr.com/photos/%1$s/sets/%2$s";
    private final Log LOG = LogFactory.getLog(this.getClass());
    private ProviderSupport providerSupport;
    private String userId = null;

    public AlbumsPluginImpl(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }

    @Override
    public List<Album> getAlbums() throws Exception {
        Element root;
        String albumUrl = String.format(ALBUMS_URL, this.providerSupport.getAccessGrant().getKey());
        Response response = this.providerSupport.api(albumUrl, MethodType.GET.toString(), null, null, null);
        try {
            root = XMLParseUtil.loadXmlResource(response.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the albums from response." + albumUrl, e);
        }
        ArrayList<Album> albums = new ArrayList<Album>();
        if (root != null) {
            NodeList cList = root.getElementsByTagName("photosets");
            if (cList != null && cList.getLength() > 0) {
                Element photosets = (Element)cList.item(0);
                NodeList photosetNodes = photosets.getElementsByTagName("photoset");
                if (photosetNodes != null && photosetNodes.getLength() > 0) {
                    this.LOG.debug((Object)("Found photo sets : " + photosetNodes.getLength()));
                    int i = 0;
                    while (i < photosetNodes.getLength()) {
                        Element photoset = (Element)photosetNodes.item(i);
                        String id = photoset.getAttribute("id");
                        if (id != null) {
                            String uId;
                            Element cE;
                            String coverPhotoUrl;
                            NodeList coverList;
                            String title;
                            NodeList titleList;
                            Album albumObj = new Album();
                            albumObj.setId(id);
                            String photoCount = photoset.getAttribute("photos");
                            if (photoCount != null) {
                                albumObj.setPhotosCount(Integer.parseInt(photoCount));
                            }
                            if ((titleList = photoset.getElementsByTagName("title")) != null && titleList.getLength() > 0 && (title = titleList.item(0).getTextContent()) != null) {
                                albumObj.setName(title);
                            }
                            if ((coverList = photoset.getElementsByTagName("primary_photo_extras")) != null && coverList.getLength() > 0 && (coverPhotoUrl = (cE = (Element)coverList.item(0)).getAttribute("url_m")) != null) {
                                albumObj.setCoverPhoto(coverPhotoUrl);
                            }
                            if ((uId = this.getUserId()) != "") {
                                albumObj.setLink(String.format(SET_LINK, this.getUserId(), id));
                            }
                            List<Photo> photos = this.getAlbumPhotos(id);
                            albumObj.setPhotos(photos);
                            albums.add(albumObj);
                        }
                        ++i;
                    }
                }
            } else {
                this.LOG.debug((Object)("No Albums were obtained from : " + albumUrl));
            }
        }
        return albums;
    }

    private String getUserId() throws Exception {
        NodeList uList;
        Element root;
        if (this.userId != null) {
            return this.userId;
        }
        String profileUrl = String.format(PROFILE_URL, this.providerSupport.getAccessGrant().getKey());
        Response response = this.providerSupport.api(profileUrl, MethodType.GET.toString(), null, null, null);
        try {
            root = XMLParseUtil.loadXmlResource(response.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the User from response." + profileUrl, e);
        }
        String id = "";
        if (root != null && (uList = root.getElementsByTagName("user")) != null && uList.getLength() > 0) {
            Element user = (Element)uList.item(0);
            id = user.getAttribute("nsid");
        }
        return id;
    }

    private List<Photo> getAlbumPhotos(String id) throws Exception {
        Element root;
        String url = String.format(ALBUM_PHOTOS_URL, id, this.providerSupport.getAccessGrant().getKey());
        Response response = this.providerSupport.api(url, MethodType.GET.toString(), null, null, null);
        this.LOG.info((Object)("Getting Photos of Album :: " + id));
        try {
            root = XMLParseUtil.loadXmlResource(response.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the photos from response." + url + id, e);
        }
        ArrayList<Photo> photos = new ArrayList<Photo>();
        if (root != null) {
            NodeList photoList = root.getElementsByTagName("photo");
            if (photoList != null && photoList.getLength() > 0) {
                this.LOG.info((Object)("Found photos : " + photoList.getLength()));
                int i = 0;
                while (i < photoList.getLength()) {
                    Photo photo = new Photo();
                    Element pl = (Element)photoList.item(i);
                    String photoId = pl.getAttribute("id");
                    photo.setId(photoId);
                    photo.setTitle(pl.getAttribute("title"));
                    String uId = this.getUserId();
                    if (uId != "") {
                        String link = String.format(PHOTO_LINK, uId, photoId);
                        photo.setLink(link);
                    }
                    photo.setLargeImage(pl.getAttribute("url_o"));
                    photo.setMediumImage(pl.getAttribute("url_m"));
                    photo.setSmallImage(pl.getAttribute("url_s"));
                    photo.setThumbImage(pl.getAttribute("url_t"));
                    photos.add(photo);
                    ++i;
                }
            } else {
                this.LOG.info((Object)("No photos were obtained from : " + url));
            }
        }
        return photos;
    }

    @Override
    public ProviderSupport getProviderSupport() {
        return this.providerSupport;
    }

    @Override
    public void setProviderSupport(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }
}

