/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.exception.SocialAuthConfigurationException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.provider.FacebookImpl;
import org.brickred.socialauth.provider.FourSquareImpl;
import org.brickred.socialauth.provider.GoogleImpl;
import org.brickred.socialauth.provider.HotmailImpl;
import org.brickred.socialauth.provider.LinkedInImpl;
import org.brickred.socialauth.provider.MySpaceImpl;
import org.brickred.socialauth.provider.OpenIdImpl;
import org.brickred.socialauth.provider.TwitterImpl;
import org.brickred.socialauth.provider.YahooImpl;
import org.brickred.socialauth.util.OAuthConfig;

@Deprecated
public class AuthProviderFactory {
    private static String propFileName = "oauth_consumer.properties";
    private static Map<String, Class> providerMap;
    private static Map<String, String> domainMap;
    private static final Log LOG;

    static {
        LOG = LogFactory.getLog(AuthProviderFactory.class);
        providerMap = new HashMap<String, Class>();
        providerMap.put("facebook", FacebookImpl.class);
        providerMap.put("foursquare", FourSquareImpl.class);
        providerMap.put("google", GoogleImpl.class);
        providerMap.put("hotmail", HotmailImpl.class);
        providerMap.put("linkedin", LinkedInImpl.class);
        providerMap.put("myspace", MySpaceImpl.class);
        providerMap.put("openid", OpenIdImpl.class);
        providerMap.put("twitter", TwitterImpl.class);
        providerMap.put("yahoo", YahooImpl.class);
        domainMap = new HashMap<String, String>();
        domainMap.put("google", "www.google.com");
        domainMap.put("yahoo", "api.login.yahoo.com");
        domainMap.put("twitter", "twitter.com");
        domainMap.put("facebook", "graph.facebook.com");
        domainMap.put("hotmail", "consent.live.com");
        domainMap.put("linkedin", "api.linkedin.com");
        domainMap.put("foursquare", "foursquare.com");
        domainMap.put("myspace", "api.myspace.com");
    }

    public static AuthProvider getInstance(String id) throws Exception {
        AuthProvider provider = AuthProviderFactory.getProvider(id, propFileName, null);
        return provider;
    }

    public static AuthProvider getInstance(String id, String propertiesFileName) throws Exception {
        AuthProvider provider = AuthProviderFactory.getProvider(id, propertiesFileName, null);
        return provider;
    }

    public static AuthProvider getInstance(String id, ClassLoader classLoader) throws Exception {
        AuthProvider provider = AuthProviderFactory.getProvider(id, propFileName, classLoader);
        return provider;
    }

    public static AuthProvider getInstance(String id, String propertiesFileName, ClassLoader classLoader) throws Exception {
        AuthProvider provider = AuthProviderFactory.getProvider(id, propertiesFileName, classLoader);
        return provider;
    }

    public static AuthProvider getInstance(String id, Properties properties) throws Exception {
        for (Object key : properties.keySet()) {
            String str = key.toString();
            if (!str.startsWith("socialauth.")) continue;
            String val = str.substring("socialauth.".length());
            AuthProviderFactory.registerProvider(val, Class.forName(properties.get(str).toString()));
        }
        return AuthProviderFactory.loadProvider(id, properties);
    }

    private static AuthProvider getProvider(String id, String fileName, ClassLoader classLoader) throws Exception {
        Properties props = new Properties();
        ClassLoader loader = null;
        loader = classLoader != null ? classLoader : AuthProviderFactory.class.getClassLoader();
        try {
            InputStream in = loader.getResourceAsStream(fileName);
            props.load(in);
            for (Object key : props.keySet()) {
                String str = key.toString();
                if (!str.startsWith("socialauth.")) continue;
                String val = str.substring("socialauth.".length());
                AuthProviderFactory.registerProvider(val, Class.forName(props.get(str).toString()));
            }
        }
        catch (NullPointerException ne) {
            throw new FileNotFoundException(String.valueOf(fileName) + " file is not found in your class path");
        }
        catch (IOException ie) {
            throw new IOException("Could not load configuration from " + fileName);
        }
        AuthProvider provider = AuthProviderFactory.loadProvider(id, props);
        return provider;
    }

    private static AuthProvider loadProvider(String id, Properties props) throws Exception {
        AuthProvider provider;
        OAuthConfig conf;
        Class obj = providerMap.get(id);
        props.setProperty("id", id);
        if (obj == null) {
            try {
                new URL(id);
                obj = providerMap.get("openid");
                conf = new OAuthConfig(null, null);
                conf.setId(id);
            }
            catch (MalformedURLException me) {
                throw new SocialAuthException(String.valueOf(id) + " is not a provider or valid OpenId URL");
            }
        } else {
            String key = domainMap.containsKey(id) ? domainMap.get(id) : id;
            String consumerKey = props.getProperty(String.valueOf(key) + ".consumer_key");
            if (consumerKey == null) {
                throw new IllegalStateException(String.valueOf(key) + ".consumer_key not found.");
            }
            String consumerSecret = props.getProperty(String.valueOf(key) + ".consumer_secret");
            if (consumerSecret == null) {
                throw new IllegalStateException(String.valueOf(key) + ".consumer_secret not found.");
            }
            conf = new OAuthConfig(consumerKey, consumerSecret);
            conf.setId(id);
        }
        try {
            Constructor cons = obj.getConstructor(OAuthConfig.class);
            provider = (AuthProvider)cons.newInstance(conf);
        }
        catch (NoSuchMethodException me) {
            LOG.warn((Object)(String.valueOf(obj.getName()) + " does not implement a constructor " + obj.getName() + "(OAuthConfig providerConfig)"));
            provider = (AuthProvider)obj.newInstance();
        }
        catch (Exception e) {
            throw new SocialAuthConfigurationException(e);
        }
        return provider;
    }

    public static void registerProvider(String pname, Class clazz) {
        providerMap.put(pname, clazz);
    }
}

