/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.plugin.Plugin;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.ProviderSupport;

public abstract class AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = -7827145708317886744L;
    private Map<Class<? extends Plugin>, Class<? extends Plugin>> pluginsMap;
    private final Log LOG = LogFactory.getLog(this.getClass());

    public AbstractProvider() throws Exception {
        this.pluginsMap = new HashMap<Class<? extends Plugin>, Class<? extends Plugin>>();
    }

    @Override
    public <T> T getPlugin(Class<T> clazz) throws Exception {
        Class<? extends Plugin> plugin = this.pluginsMap.get(clazz);
        Constructor<? extends Plugin> cons = plugin.getConstructor(ProviderSupport.class);
        ProviderSupport support = new ProviderSupport(this.getOauthStrategy());
        Plugin obj = cons.newInstance(support);
        return (T)obj;
    }

    @Override
    public boolean isSupportedPlugin(Class<? extends Plugin> clazz) {
        return this.pluginsMap.containsKey(clazz);
    }

    @Override
    public final void registerPlugins() throws Exception {
        this.LOG.info((Object)"Loading plugins");
        List<String> pluginsList = this.getPluginsList();
        if (pluginsList != null && !pluginsList.isEmpty()) {
            for (String s : pluginsList) {
                Class<?>[] interfaces;
                this.LOG.info((Object)("Loading plugin :: " + s));
                Class<Plugin> clazz = Class.forName(s).asSubclass(Plugin.class);
                Constructor<Plugin> cons = clazz.getConstructor(ProviderSupport.class);
                Class<?>[] classArray = interfaces = clazz.getInterfaces();
                int n = interfaces.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> c = classArray[n2];
                    if (Plugin.class.isAssignableFrom(c)) {
                        this.pluginsMap.put(c.asSubclass(Plugin.class), clazz);
                    }
                    ++n2;
                }
            }
        }
    }

    @Override
    public void refreshToken(AccessGrant accessGrant) throws SocialAuthException {
        throw new SocialAuthException("Not implemented for given provider");
    }

    public String getPluginsScope(OAuthConfig oauthConfig) {
        List<String> scopes = oauthConfig.getPluginsScopes();
        if (scopes != null && !scopes.isEmpty()) {
            String scopesStr = scopes.get(0);
            int i = 1;
            while (i < scopes.size()) {
                scopesStr = String.valueOf(scopesStr) + "," + scopes.get(i);
                ++i;
            }
            return scopesStr;
        }
        return null;
    }

    protected abstract List<String> getPluginsList();

    protected abstract OAuthStrategyBase getOauthStrategy();
}

