/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.oauthstrategy.OAuth1;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.BirthDate;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.XMLParseUtil;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class YahooImpl
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = 903564874550419470L;
    private static final String PROFILE_URL = "http://social.yahooapis.com/v1/user/%1$s/profile?format=json";
    private static final String CONTACTS_URL = "http://social.yahooapis.com/v1/user/%1$s/contacts;count=max";
    private static final String UPDATE_STATUS_URL = "http://social.yahooapis.com/v1/user/%1$s/profile/status";
    private final Log LOG = LogFactory.getLog(YahooImpl.class);
    private static final Map<String, String> ENDPOINTS = new HashMap<String, String>();
    private Permission scope;
    private AccessGrant accessToken;
    private OAuthConfig config;
    private Profile userProfile;
    private OAuthStrategyBase authenticationStrategy;

    public YahooImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getRequestTokenUrl() != null) {
            ENDPOINTS.put("reqTokenURL", this.config.getRequestTokenUrl());
        } else {
            this.config.setRequestTokenUrl(ENDPOINTS.get("reqTokenURL"));
        }
        if (this.config.getAuthenticationUrl() != null) {
            ENDPOINTS.put("authorizationURL", this.config.getAuthenticationUrl());
        } else {
            this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        }
        if (this.config.getAccessTokenUrl() != null) {
            ENDPOINTS.put("accessTokenURL", this.config.getAccessTokenUrl());
        } else {
            this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
        }
        this.authenticationStrategy = new OAuth1(this.config, ENDPOINTS);
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException {
        this.accessToken = accessGrant;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        String url = null;
        try {
            url = this.authenticationStrategy.getLoginRedirectURL(successUrl);
        }
        catch (SocialAuthException ex) {
            String msg = ex.getMessage() + "OR you have not set any scope while registering your application. You will have to select atlest read public profile scope while registering your application";
            throw new SocialAuthException(msg, ex);
        }
        return url;
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        this.accessToken = this.authenticationStrategy.verifyResponse(requestParams);
        return this.getProfile();
    }

    private Profile getProfile() throws Exception {
        String result;
        this.LOG.debug((Object)"Obtaining user profile");
        Profile profile = new Profile();
        String guid = (String)this.accessToken.getAttribute("xoauth_yahoo_guid");
        if (guid.indexOf("<") != -1) {
            guid = guid.substring(0, guid.indexOf("<")).trim();
            this.accessToken.setAttribute("xoauth_yahoo_guid", guid);
        }
        String url = String.format(PROFILE_URL, guid);
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(url);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + url, e);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + url + ". Staus :" + serviceResponse.getStatus());
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("User Profile :" + result));
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read response from  " + url, exc);
        }
        try {
            JSONObject jobj = new JSONObject(result);
            if (jobj.has("profile")) {
                JSONObject imgObj;
                String dstr;
                JSONObject pObj = jobj.getJSONObject("profile");
                if (pObj.has("guid")) {
                    profile.setValidatedId(pObj.getString("guid"));
                }
                if (pObj.has("familyName")) {
                    profile.setLastName(pObj.getString("familyName"));
                }
                if (pObj.has("gender")) {
                    profile.setGender(pObj.getString("gender"));
                }
                if (pObj.has("givenName")) {
                    profile.setFirstName(pObj.getString("givenName"));
                }
                if (pObj.has("location")) {
                    profile.setLocation(pObj.getString("location"));
                }
                if (pObj.has("nickname")) {
                    profile.setDisplayName(pObj.getString("nickname"));
                }
                if (pObj.has("lang")) {
                    profile.setLanguage(pObj.getString("lang"));
                }
                if (pObj.has("birthdate") && (dstr = pObj.getString("birthdate")) != null) {
                    String[] arr = dstr.split("/");
                    BirthDate bd = new BirthDate();
                    if (arr.length > 0) {
                        bd.setMonth(Integer.parseInt(arr[0]));
                    }
                    if (arr.length > 1) {
                        bd.setDay(Integer.parseInt(arr[1]));
                    }
                    profile.setDob(bd);
                }
                if (pObj.has("image") && (imgObj = pObj.getJSONObject("image")).has("imageUrl")) {
                    profile.setProfileImageURL(imgObj.getString("imageUrl"));
                }
                if (pObj.has("emails")) {
                    JSONArray earr = pObj.getJSONArray("emails");
                    for (int i = 0; i < earr.length(); ++i) {
                        JSONObject eobj = earr.getJSONObject(i);
                        if (!eobj.has("primary") || !"true".equals(eobj.getString("primary"))) continue;
                        if (!eobj.has("handle")) break;
                        profile.setEmail(eobj.getString("handle"));
                        break;
                    }
                }
            }
            profile.setProviderId(this.getProviderId());
            this.userProfile = profile;
            return profile;
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the user profile json : " + result, e);
        }
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        Element root;
        String url = String.format(CONTACTS_URL, this.accessToken.getAttribute("xoauth_yahoo_guid"));
        this.LOG.info((Object)("Fetching contacts from " + url));
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(url);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the contacts from " + url, ie);
        }
        ArrayList<Contact> plist = new ArrayList<Contact>();
        try {
            root = XMLParseUtil.loadXmlResource(serviceResponse.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the contacts from response." + url, e);
        }
        NodeList contactsList = root.getElementsByTagName("contact");
        if (contactsList != null && contactsList.getLength() > 0) {
            this.LOG.debug((Object)("Found contacts : " + contactsList.getLength()));
            for (int i = 0; i < contactsList.getLength(); ++i) {
                Element contact = (Element)contactsList.item(i);
                NodeList fieldList = contact.getElementsByTagName("fields");
                if (fieldList == null || fieldList.getLength() <= 0) continue;
                String fname = "";
                String lname = "";
                String dispName = "";
                String address = "";
                ArrayList<String> emailArr = new ArrayList<String>();
                for (int j = 0; j < fieldList.getLength(); ++j) {
                    Element field = (Element)fieldList.item(j);
                    String type = XMLParseUtil.getElementData(field, "type");
                    if ("email".equalsIgnoreCase(type)) {
                        if (address.length() > 0) {
                            emailArr.add(XMLParseUtil.getElementData(field, "value"));
                            continue;
                        }
                        address = XMLParseUtil.getElementData(field, "value");
                        continue;
                    }
                    if ("name".equals(type)) {
                        fname = XMLParseUtil.getElementData(field, "givenName");
                        lname = XMLParseUtil.getElementData(field, "familyName");
                        continue;
                    }
                    if (!"yahooid".equalsIgnoreCase(type)) continue;
                    dispName = XMLParseUtil.getElementData(field, "value");
                }
                if (address == null || address.length() <= 0) continue;
                Contact p = new Contact();
                p.setFirstName(fname);
                p.setLastName(lname);
                p.setEmail(address);
                p.setDisplayName(dispName);
                if (emailArr.size() > 0) {
                    String[] arr = new String[emailArr.size()];
                    int k = 0;
                    Iterator i$ = emailArr.iterator();
                    while (i$.hasNext()) {
                        String s;
                        arr[k] = s = (String)i$.next();
                        ++k;
                    }
                    p.setOtherEmails(arr);
                }
                p.setId(contact.getAttribute("yahoo:uri"));
                plist.add(p);
            }
        } else {
            this.LOG.debug((Object)"No contacts were obtained from : http://social.yahooapis.com/v1/user/%1$s/contacts;count=max");
        }
        return plist;
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        if (msg == null || msg.trim().length() == 0) {
            throw new ServerDataException("Status cannot be blank");
        }
        String url = String.format(UPDATE_STATUS_URL, this.accessToken.getAttribute("xoauth_yahoo_guid"));
        this.LOG.info((Object)("Updating status " + msg + " on " + url));
        String msgBody = "{\"status\":{\"message\":\"" + msg + "\"}}";
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(url, MethodType.PUT.toString(), null, null, msgBody);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to update status on " + url, ie);
        }
        if (serviceResponse.getStatus() != 204) {
            throw new SocialAuthException("Failed to update status. Return status code :" + serviceResponse.getStatus());
        }
        this.LOG.debug((Object)("Status Updated and return status code is : " + serviceResponse.getStatus()));
        return serviceResponse;
    }

    @Override
    public void logout() {
        this.accessToken = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        String urlStr = String.format(url, this.accessToken.getAttribute("xoauth_yahoo_guid"));
        this.LOG.debug((Object)("Calling URL : " + urlStr));
        return this.authenticationStrategy.executeFeed(urlStr, methodType, params, headerParams, body);
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessToken != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessToken;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Yahoo");
        throw new SocialAuthException("Upload Image is not implemented for Yahoo");
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }

    static {
        ENDPOINTS.put("reqTokenURL", "https://api.login.yahoo.com/oauth/v2/get_request_token");
        ENDPOINTS.put("authorizationURL", "https://api.login.yahoo.com//oauth/v2/request_auth");
        ENDPOINTS.put("accessTokenURL", "https://api.login.yahoo.com/oauth/v2/get_token");
    }
}

