/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.AccessTokenExpireException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuth2;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.XMLParseUtil;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class GooglePlusImpl
extends AbstractProvider {
    private static final long serialVersionUID = 8644510564735754296L;
    private static final String PROFILE_URL = "https://www.googleapis.com/oauth2/v1/userinfo";
    private static final String CONTACTS_FEED_URL = "https://www.google.com/m8/feeds/contacts/default/full/?max-results=1000";
    private static final String CONTACT_NAMESPACE = "http://schemas.google.com/g/2005";
    private static final Map<String, String> ENDPOINTS;
    private final Log LOG = LogFactory.getLog(GooglePlusImpl.class);
    private Permission scope;
    private OAuthConfig config;
    private Profile userProfile;
    private AccessGrant accessGrant;
    private OAuthStrategyBase authenticationStrategy;
    private static final String[] AllPerms;
    private static final String[] AuthPerms;

    static {
        AllPerms = new String[]{"https://www.googleapis.com/auth/userinfo.profile", "https://www.googleapis.com/auth/userinfo.email", "https://www.googleapis.com/auth/plus.login", "https://www.google.com/m8/feeds", "https://picasaweb.google.com/data/"};
        AuthPerms = new String[]{"https://www.googleapis.com/auth/userinfo.profile", "https://www.googleapis.com/auth/userinfo.email"};
        ENDPOINTS = new HashMap<String, String>();
        ENDPOINTS.put("authorizationURL", "https://accounts.google.com/o/oauth2/auth");
        ENDPOINTS.put("accessTokenURL", "https://accounts.google.com/o/oauth2/token");
    }

    public GooglePlusImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
        if (this.config.getAuthenticationUrl() != null) {
            ENDPOINTS.put("authorizationURL", this.config.getAuthenticationUrl());
        } else {
            this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        }
        if (this.config.getAccessTokenUrl() != null) {
            ENDPOINTS.put("accessTokenURL", this.config.getAccessTokenUrl());
        } else {
            this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
        }
        this.authenticationStrategy = new OAuth2(this.config, ENDPOINTS);
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws AccessTokenExpireException {
        this.accessGrant = accessGrant;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Retrieving Access Token in verify response function");
        if (requestParams.get("error_reason") != null && "user_denied".equals(requestParams.get("error_reason"))) {
            throw new UserDeniedPermissionException();
        }
        this.accessGrant = this.authenticationStrategy.verifyResponse(requestParams, MethodType.POST.toString());
        if (this.accessGrant != null) {
            this.LOG.debug((Object)"Obtaining user profile");
            return this.getProfile();
        }
        throw new SocialAuthException("Access token not found");
    }

    private Profile getProfile() throws Exception {
        String presp;
        try {
            Response response = this.authenticationStrategy.executeFeed(PROFILE_URL);
            presp = response.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting profile from https://www.googleapis.com/oauth2/v1/userinfo", e);
        }
        try {
            this.LOG.debug((Object)("User Profile : " + presp));
            JSONObject resp = new JSONObject(presp);
            Profile p = new Profile();
            p.setValidatedId(resp.getString("id"));
            if (resp.has("name")) {
                p.setFullName(resp.getString("name"));
            }
            if (resp.has("given_name")) {
                p.setFirstName(resp.getString("given_name"));
            }
            if (resp.has("family_name")) {
                p.setLastName(resp.getString("family_name"));
            }
            if (resp.has("email")) {
                p.setEmail(resp.getString("email"));
            }
            if (resp.has("gender")) {
                p.setGender(resp.getString("gender"));
            }
            if (resp.has("picture")) {
                p.setProfileImageURL(resp.getString("picture"));
            }
            if (resp.has("id")) {
                p.setValidatedId(resp.getString("id"));
            }
            p.setProviderId(this.getProviderId());
            this.userProfile = p;
            return p;
        }
        catch (Exception ex) {
            throw new ServerDataException("Failed to parse the user profile json : " + presp, ex);
        }
    }

    @Override
    public Response updateStatus(String msg) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for GooglePlus");
        throw new SocialAuthException("Update Status is not implemented for GooglePlus");
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        Element root;
        this.LOG.info((Object)"Fetching contacts from https://www.google.com/m8/feeds/contacts/default/full/?max-results=1000");
        if (Permission.AUTHENTICATE_ONLY.equals(this.scope)) {
            throw new SocialAuthException("You have not set Permission to get contacts.");
        }
        Response serviceResponse = null;
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("Authorization", "Bearer " + this.getAccessGrant().getKey());
            serviceResponse = this.authenticationStrategy.executeFeed(CONTACTS_FEED_URL, null, null, map, null);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the contacts from https://www.google.com/m8/feeds/contacts/default/full/?max-results=1000", ie);
        }
        ArrayList<Contact> plist = new ArrayList<Contact>();
        try {
            root = XMLParseUtil.loadXmlResource(serviceResponse.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the contacts from response.https://www.google.com/m8/feeds/contacts/default/full/?max-results=1000", e);
        }
        NodeList contactsList = root.getElementsByTagName("entry");
        if (contactsList != null && contactsList.getLength() > 0) {
            this.LOG.debug((Object)("Found contacts : " + contactsList.getLength()));
            int i = 0;
            while (i < contactsList.getLength()) {
                String[] sarr;
                Element contact = (Element)contactsList.item(i);
                String fname = "";
                NodeList l = contact.getElementsByTagNameNS(CONTACT_NAMESPACE, "email");
                String address = null;
                String[] emailArr = null;
                if (l != null && l.getLength() > 0) {
                    Element el = (Element)l.item(0);
                    if (el != null) {
                        address = el.getAttribute("address");
                    }
                    if (l.getLength() > 1) {
                        emailArr = new String[l.getLength() - 1];
                        int k = 1;
                        while (k < l.getLength()) {
                            Element e = (Element)l.item(k);
                            if (e != null) {
                                emailArr[k - 1] = e.getAttribute("address");
                            }
                            ++k;
                        }
                    }
                }
                String lname = "";
                String dispName = XMLParseUtil.getElementData(contact, "title");
                if (dispName != null && (sarr = dispName.split(" ")).length > 0) {
                    if (sarr.length >= 1) {
                        fname = sarr[0];
                    }
                    if (sarr.length >= 2) {
                        StringBuilder sb = new StringBuilder();
                        int k = 1;
                        while (k < sarr.length) {
                            sb.append(sarr[k]).append(" ");
                            ++k;
                        }
                        lname = sb.toString();
                    }
                }
                String id = XMLParseUtil.getElementData(contact, "id");
                if (address != null && address.length() > 0) {
                    Contact p = new Contact();
                    p.setFirstName(fname);
                    p.setLastName(lname);
                    p.setEmail(address);
                    p.setDisplayName(dispName);
                    p.setOtherEmails(emailArr);
                    p.setId(id);
                    plist.add(p);
                }
                ++i;
            }
        } else {
            this.LOG.debug((Object)"No contacts were obtained from the feed : https://www.google.com/m8/feeds/contacts/default/full/?max-results=1000");
        }
        return plist;
    }

    @Override
    public void logout() {
        this.accessGrant = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        this.LOG.info((Object)("Calling api function for url\t:\t" + url));
        Response response = null;
        try {
            response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while making request to URL : " + url, e);
        }
        return response;
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessGrant != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessGrant;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for GooglePlus");
        throw new SocialAuthException("Upload Image is not implemented for GooglePlus");
    }

    private String getScope() {
        StringBuffer result = new StringBuffer();
        String[] arr = null;
        arr = Permission.AUTHENTICATE_ONLY.equals(this.scope) ? AuthPerms : (Permission.CUSTOM.equals(this.scope) && this.config.getCustomPermissions() != null ? this.config.getCustomPermissions().split(",") : AllPerms);
        result.append(arr[0]);
        int i = 1;
        while (i < arr.length) {
            result.append("+").append(arr[i]);
            ++i;
        }
        String pluginScopes = this.getPluginsScope(this.config);
        if (pluginScopes != null) {
            result.append("+").append(pluginScopes);
        }
        return result.toString();
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("org.brickred.socialauth.plugin.googleplus.FeedPluginImpl");
        list.add("org.brickred.socialauth.plugin.googleplus.AlbumsPluginImpl");
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }
}

