/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.plugin.googleplus;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Feed;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.plugin.FeedPlugin;
import org.brickred.socialauth.util.ProviderSupport;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class FeedPluginImpl
implements FeedPlugin,
Serializable {
    private static final long serialVersionUID = -65514329203379220L;
    private static final String FEED_URL = "https://www.googleapis.com/plus/v1/people/me/activities/public?maxResults=100";
    private ProviderSupport providerSupport;
    private static final DateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'hh:mm:ss.SSS'Z'");
    private final Log LOG = LogFactory.getLog(this.getClass());

    public FeedPluginImpl(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    public ProviderSupport getProviderSupport() {
        return this.providerSupport;
    }

    @Override
    public void setProviderSupport(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }

    @Override
    public List<Feed> getFeeds() throws Exception {
        this.LOG.info((Object)"getting feeds for google plus");
        ArrayList<Feed> list = new ArrayList<Feed>();
        try {
            Response response = this.providerSupport.api(FEED_URL);
            String respStr = response.getResponseBodyAsString("UTF-8");
            System.out.println(respStr);
            JSONObject resp = new JSONObject(respStr);
            JSONArray items = resp.getJSONArray("items");
            this.LOG.debug((Object)("Feeds count : " + items.length()));
            for (int i = 0; i < items.length(); ++i) {
                JSONObject actor;
                Feed feed = new Feed();
                JSONObject obj = items.getJSONObject(i);
                if (obj.has("title")) {
                    feed.setMessage(obj.getString("title"));
                }
                if (obj.has("id")) {
                    feed.setId(obj.getString("id"));
                }
                if (obj.has("actor") && (actor = obj.getJSONObject("actor")).has("displayName")) {
                    feed.setFrom(actor.getString("displayName"));
                }
                if (obj.has("published")) {
                    Date date = dateFormat.parse(obj.getString("published"));
                    feed.setCreatedAt(date);
                }
                System.out.println(feed);
                list.add(feed);
            }
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting Feeds from https://www.googleapis.com/plus/v1/people/me/activities/public?maxResults=100", e);
        }
        return list;
    }
}

