/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.oauthstrategy;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.exception.ProviderStateException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.HttpUtil;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.OAuthConsumer;
import org.brickred.socialauth.util.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class OAuth2
implements OAuthStrategyBase {
    private static final long serialVersionUID = -8431902665718727947L;
    private final Log LOG = LogFactory.getLog(OAuth2.class);
    private AccessGrant accessGrant;
    private OAuthConsumer oauth;
    private boolean providerState;
    private Map<String, String> endpoints;
    private String scope;
    private Permission permission;
    private String providerId;
    private String successUrl;
    private String accessTokenParameterName;

    public OAuth2(OAuthConfig config, Map<String, String> endpoints) {
        this.oauth = new OAuthConsumer(config);
        this.endpoints = endpoints;
        this.permission = Permission.DEFAULT;
        this.providerId = config.getId();
        this.accessTokenParameterName = "access_token";
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        return this.getLoginRedirectURL(successUrl, null);
    }

    @Override
    public String getLoginRedirectURL(String successUrl, Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Determining URL for redirection");
        this.providerState = true;
        try {
            this.successUrl = URLEncoder.encode(successUrl, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            this.successUrl = successUrl;
        }
        StringBuffer sb = new StringBuffer();
        sb.append(this.endpoints.get("authorizationURL"));
        char separator = this.endpoints.get("authorizationURL").indexOf(63) == -1 ? (char)'?' : '&';
        sb.append(separator);
        sb.append("client_id=").append(this.oauth.getConfig().get_consumerKey());
        sb.append("&response_type=code");
        sb.append("&redirect_uri=").append(this.successUrl);
        if (this.scope != null) {
            sb.append("&scope=").append(this.scope);
        }
        if (requestParams != null && !requestParams.isEmpty()) {
            for (String key : requestParams.keySet()) {
                sb.append("&");
                sb.append(key).append("=").append(requestParams.get(key));
            }
        }
        String url = sb.toString();
        this.LOG.info((Object)("Redirection to following URL should happen : " + url));
        return url;
    }

    @Override
    public AccessGrant verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.verifyResponse(requestParams, MethodType.GET.toString());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public AccessGrant verifyResponse(Map<String, String> requestParams, String methodType) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        if (requestParams.get("access_token") != null) {
            this.LOG.debug((Object)"Creating Access Grant");
            accessToken = requestParams.get("access_token");
            expires = null;
            if (requestParams.get("expires") != null) {
                expires = new Integer(requestParams.get("expires"));
            }
            this.accessGrant = new AccessGrant();
            this.accessGrant.setKey(accessToken);
            this.accessGrant.setAttribute("expires", expires);
            if (this.permission != null) {
                this.accessGrant.setPermission(this.permission);
            } else {
                this.accessGrant.setPermission(Permission.ALL);
            }
            this.accessGrant.setProviderId(this.providerId);
            this.LOG.debug((Object)this.accessGrant);
            return this.accessGrant;
        }
        if (!this.providerState) {
            throw new ProviderStateException();
        }
        code = requestParams.get("code");
        if (code == null || code.length() == 0) {
            throw new SocialAuthException("Verification code is null");
        }
        this.LOG.debug((Object)("Verification Code : " + code));
        accessToken = null;
        try {
            acode = URLEncoder.encode(code, "UTF-8");
        }
        catch (Exception e) {
            acode = code;
        }
        sb = new StringBuffer();
        if (MethodType.GET.toString().equals(methodType)) {
            sb.append(this.endpoints.get("accessTokenURL"));
            separator = this.endpoints.get("accessTokenURL").indexOf(63) == -1 ? '?' : '&';
            sb.append(separator);
        }
        sb.append("client_id=").append(this.oauth.getConfig().get_consumerKey());
        sb.append("&redirect_uri=").append(this.successUrl);
        sb.append("&client_secret=").append(this.oauth.getConfig().get_consumerSecret());
        sb.append("&code=").append(acode);
        sb.append("&grant_type=authorization_code");
        authURL = null;
        try {
            if (MethodType.GET.toString().equals(methodType)) {
                authURL = sb.toString();
                this.LOG.debug((Object)("URL for Access Token request : " + authURL));
                response = HttpUtil.doHttpRequest(authURL, methodType, null, null);
            } else {
                authURL = this.endpoints.get("accessTokenURL");
                this.LOG.debug((Object)("URL for Access Token request : " + authURL));
                response = HttpUtil.doHttpRequest(authURL, methodType, sb.toString(), null);
            }
        }
        catch (Exception e) {
            throw new SocialAuthException("Error in url : " + authURL, e);
        }
        try {
            result = response.getResponseBodyAsString("UTF-8");
        }
        catch (IOException io) {
            throw new SocialAuthException(io);
        }
        attributes = new HashMap<String, Object>();
        expires = null;
        if (result.indexOf("{") < 0) {
            for (String pair : pairs = result.split("&")) {
                kv = pair.split("=");
                if (kv.length != 2) {
                    throw new SocialAuthException("Unexpected auth response from " + authURL);
                }
                if (kv[0].equals("access_token")) {
                    accessToken = kv[1];
                    continue;
                }
                if (kv[0].equals("expires")) {
                    expires = Integer.valueOf(kv[1]);
                    continue;
                }
                if (kv[0].equals("expires_in")) {
                    expires = Integer.valueOf(kv[1]);
                    continue;
                }
                attributes.put(kv[0], kv[1]);
            }
        } else {
            try {
                jObj = new JSONObject(result);
                if (jObj.has("access_token")) {
                    accessToken = jObj.getString("access_token");
                }
                if (jObj.has("expires_in") && jObj.opt("expires_in") != null && (str = jObj.get("expires_in").toString()) != null && str.length() > 0) {
                    expires = Integer.valueOf(str);
                }
                if (accessToken == null) ** GOTO lbl102
                keyItr = jObj.keys();
                while (keyItr.hasNext()) {
                    key = (String)keyItr.next();
                    if ("access_token".equals(key) || "expires_in".equals(key) || jObj.opt(key) == null) continue;
                    attributes.put(key, jObj.opt(key).toString());
                }
            }
            catch (JSONException je) {
                throw new SocialAuthException("Unexpected auth response from " + authURL);
            }
        }
lbl102:
        // 3 sources

        this.LOG.debug((Object)("Access Token : " + accessToken));
        this.LOG.debug((Object)("Expires : " + expires));
        if (accessToken != null) {
            this.accessGrant = new AccessGrant();
            this.accessGrant.setKey(accessToken);
            this.accessGrant.setAttribute("expires", expires);
            if (attributes.size() > 0) {
                this.accessGrant.setAttributes(attributes);
            }
            if (this.permission != null) {
                this.accessGrant.setPermission(this.permission);
            } else {
                this.accessGrant.setPermission(Permission.ALL);
            }
        } else {
            throw new SocialAuthException("Access token and expires not found from " + authURL);
        }
        this.accessGrant.setProviderId(this.providerId);
        return this.accessGrant;
    }

    @Override
    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    @Override
    public Response executeFeed(String url) throws Exception {
        if (this.accessGrant == null) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        char separator = url.indexOf(63) == -1 ? (char)'?' : '&';
        String urlStr = url + separator + this.accessTokenParameterName + "=" + this.accessGrant.getKey();
        this.LOG.debug((Object)("Calling URL : " + urlStr));
        return HttpUtil.doHttpRequest(urlStr, MethodType.GET.toString(), null, null);
    }

    @Override
    public Response executeFeed(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        if (this.accessGrant == null) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        String reqURL = url;
        String bodyStr = body;
        StringBuffer sb = new StringBuffer();
        sb.append(this.accessTokenParameterName).append("=").append(this.accessGrant.getKey());
        if (params != null && params.size() > 0) {
            for (String key : params.keySet()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(key).append("=").append(params.get(key));
            }
        }
        if (MethodType.GET.toString().equals(methodType)) {
            if (sb.length() > 0) {
                int idx = url.indexOf(63);
                reqURL = idx == -1 ? reqURL + "?" : reqURL + "&";
                reqURL = reqURL + sb.toString();
            }
        } else if ((MethodType.POST.toString().equals(methodType) || MethodType.PUT.toString().equals(methodType)) && sb.length() > 0) {
            if (bodyStr != null) {
                if (headerParams != null && headerParams.containsKey("Content-Type")) {
                    String val = headerParams.get("Content-Type");
                    if (!"application/json".equals(val) && val.indexOf("text/xml") == -1) {
                        bodyStr = bodyStr + "&";
                        bodyStr = bodyStr + sb.toString();
                    }
                } else {
                    bodyStr = bodyStr + "&";
                    bodyStr = bodyStr + sb.toString();
                }
            } else {
                bodyStr = sb.toString();
            }
        }
        this.LOG.debug((Object)("Calling URL\t:\t" + reqURL));
        this.LOG.debug((Object)("Body\t\t:\t" + bodyStr));
        this.LOG.debug((Object)("Header Params\t:\t" + headerParams));
        return HttpUtil.doHttpRequest(reqURL, methodType, bodyStr, headerParams);
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) {
        this.accessGrant = accessGrant;
    }

    @Override
    public void setAccessTokenParameterName(String accessTokenParameterName) {
        this.accessTokenParameterName = accessTokenParameterName;
    }

    @Override
    public void logout() {
        this.accessGrant = null;
        this.providerState = false;
    }

    @Override
    public Response uploadImage(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String fileName, InputStream inputStream, String fileParamName) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(this.accessTokenParameterName, this.accessGrant.getKey());
        if (params != null && params.size() > 0) {
            map.putAll(params);
        }
        return HttpUtil.doHttpRequest(url, methodType, map, headerParams, inputStream, fileName, null);
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessGrant;
    }
}

