/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuth2;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.BirthDate;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.json.JSONObject;

public class RunkeeperImpl
extends AbstractProvider {
    private static final long serialVersionUID = 8644510564735754296L;
    private static final String PROFILE_URL = "http://api.runkeeper.com/profile";
    private static final Map<String, String> ENDPOINTS = new HashMap<String, String>();
    private final Log LOG = LogFactory.getLog(RunkeeperImpl.class);
    private Permission scope;
    private OAuthConfig config;
    private Profile userProfile;
    private AccessGrant accessGrant;
    private OAuthStrategyBase authenticationStrategy;

    public RunkeeperImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
        this.authenticationStrategy = new OAuth2(this.config, ENDPOINTS);
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
        this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws Exception {
        this.accessGrant = accessGrant;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Retrieving Access Token in verify response function");
        if (requestParams.get("error") != null && "access_denied".equals(requestParams.get("error"))) {
            throw new UserDeniedPermissionException();
        }
        this.accessGrant = this.authenticationStrategy.verifyResponse(requestParams, MethodType.POST.toString());
        if (this.accessGrant != null) {
            this.LOG.debug((Object)"Obtaining user profile");
            return this.getProfile();
        }
        throw new SocialAuthException("Access token not found");
    }

    private Profile getProfile() throws Exception {
        String presp;
        try {
            HashMap<String, String> hmap = new HashMap<String, String>();
            hmap.put("Accept", "application/vnd.com.runkeeper.Profile+json");
            Response response = this.authenticationStrategy.executeFeed(PROFILE_URL, MethodType.GET.toString(), null, hmap, null);
            presp = response.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting profile from http://api.runkeeper.com/profile", e);
        }
        try {
            String bstr;
            this.LOG.debug((Object)("User Profile : " + presp));
            JSONObject resp = new JSONObject(presp);
            Profile p = new Profile();
            if (resp.has("profile")) {
                String purl = resp.getString("profile");
                String[] parr = purl.split("/");
                p.setValidatedId(parr[parr.length - 1]);
            }
            if (resp.has("name")) {
                p.setFirstName(resp.getString("name"));
                p.setFullName(resp.getString("name"));
            }
            if (resp.has("location")) {
                p.setLocation(resp.getString("location"));
            }
            if (resp.has("birthday") && (bstr = resp.getString("birthday")) != null && bstr.matches("[A-Za-z]{3}, \\d{1,2} [A-Za-z]{3} \\d{4} \\d{2}:\\d{2}:\\d{2}")) {
                SimpleDateFormat df = new SimpleDateFormat("EEE, dd MMM yyyy hh:mm:ss");
                Date d = df.parse(bstr);
                Calendar c = Calendar.getInstance();
                c.setTime(d);
                BirthDate bd = new BirthDate();
                bd.setDay(c.get(5));
                bd.setYear(c.get(1));
                bd.setMonth(c.get(2) + 1);
                p.setDob(bd);
            }
            if (resp.has("gender")) {
                p.setGender(resp.getString("gender"));
            }
            if (resp.has("normal_picture")) {
                p.setProfileImageURL(resp.getString("normal_picture"));
            }
            p.setProviderId(this.getProviderId());
            this.userProfile = p;
            return p;
        }
        catch (Exception ex) {
            throw new ServerDataException("Failed to parse the user profile json : " + presp, ex);
        }
    }

    @Override
    public void updateStatus(String msg) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Runkeeper");
        throw new SocialAuthException("Update Status is not implemented for Runkeeper");
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Runkeeper");
        throw new SocialAuthException("Retrieving contacts is not implemented for Runkeeper");
    }

    @Override
    public void logout() {
        this.accessGrant = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        this.LOG.info((Object)("Calling api function for url\t:\t" + url));
        Response response = null;
        try {
            response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while making request to URL : " + url, e);
        }
        return response;
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessGrant != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessGrant;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for Runkeeper");
        throw new SocialAuthException("Upload Image is not implemented for Runkeeper");
    }

    private String getScope() {
        return null;
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }

    static {
        ENDPOINTS.put("authorizationURL", "https://runkeeper.com/apps/authorize");
        ENDPOINTS.put("accessTokenURL", "https://runkeeper.com/apps/token");
    }
}

