/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuth1;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class MySpaceImpl
extends AbstractProvider {
    private static final long serialVersionUID = -4074039782095430942L;
    private static final String PROFILE_URL = "http://api.myspace.com/1.0/people/@me/@self";
    private static final String CONTACTS_URL = "http://api.myspace.com/1.0/people/@me/@all";
    private static final String UPDATE_STATUS_URL = "http://api.myspace.com/1.0/statusmood/@me/@self";
    private static final Map<String, String> ENDPOINTS = new HashMap<String, String>();
    private final Log LOG = LogFactory.getLog(MySpaceImpl.class);
    private Permission scope;
    private AccessGrant accessToken;
    private OAuthConfig config;
    private Profile userProfile;
    private OAuthStrategyBase authenticationStrategy;
    private static final String AllPerms = "VIEWER_FULL_PROFILE_INFO|ViewFullProfileInfo|UpdateMoodStatus";
    private static final String AuthPerms = "VIEWER_FULL_PROFILE_INFO|ViewFullProfileInfo";

    public MySpaceImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
        this.authenticationStrategy = new OAuth1(this.config, ENDPOINTS);
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
        this.config.setRequestTokenUrl(ENDPOINTS.get("reqTokenURL"));
        this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws Exception {
        this.accessToken = accessGrant;
        this.scope = accessGrant.getPermission();
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        if (requestParams.get("oauth_problem") != null && "user_refused".equals(requestParams.get("oauth_problem"))) {
            throw new UserDeniedPermissionException();
        }
        this.accessToken = this.authenticationStrategy.verifyResponse(requestParams);
        return this.getProfile();
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        String result;
        if (this.accessToken == null) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        this.LOG.info((Object)"Fetching contacts from http://api.myspace.com/1.0/people/@me/@all");
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(CONTACTS_URL);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the contacts from http://api.myspace.com/1.0/people/@me/@all", ie);
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("Contacts JSON :" + result));
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read contacts from  http://api.myspace.com/1.0/people/@me/@all", exc);
        }
        JSONArray fArr = new JSONArray();
        JSONObject resObj = new JSONObject(result);
        if (!resObj.has("entry")) {
            throw new ServerDataException("Failed to parse the user Contacts json : " + result);
        }
        fArr = resObj.getJSONArray("entry");
        ArrayList<Contact> plist = new ArrayList<Contact>();
        for (int i = 0; i < fArr.length(); ++i) {
            JSONObject fObj = fArr.getJSONObject(i);
            if (!fObj.has("person")) continue;
            Contact contact = new Contact();
            JSONObject pObj = fObj.getJSONObject("person");
            if (pObj.has("displayName")) {
                contact.setDisplayName(pObj.getString("displayName"));
            }
            if (pObj.has("name")) {
                JSONObject nobj = pObj.getJSONObject("name");
                if (nobj.has("familyName")) {
                    contact.setLastName(nobj.getString("familyName"));
                }
                if (nobj.has("givenName")) {
                    contact.setFirstName(nobj.getString("givenName"));
                }
            }
            if (pObj.has("profileUrl")) {
                contact.setProfileUrl(pObj.getString("profileUrl"));
            }
            if (pObj.has("id")) {
                contact.setId(pObj.getString("id"));
            }
            plist.add(contact);
        }
        return plist;
    }

    @Override
    public void updateStatus(String msg) throws Exception {
        if (msg == null || msg.trim().length() == 0) {
            throw new ServerDataException("Status cannot be blank");
        }
        this.LOG.info((Object)("Updating status " + msg + " on " + UPDATE_STATUS_URL));
        String msgBody = "{\"status\":\"" + msg + "\"}";
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(UPDATE_STATUS_URL, MethodType.PUT.toString(), null, null, msgBody);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to update status on http://api.myspace.com/1.0/statusmood/@me/@self", ie);
        }
        this.LOG.info((Object)("Update Status Response :" + serviceResponse.getStatus()));
    }

    @Override
    public void logout() {
        this.accessToken = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    private Profile getProfile() throws Exception {
        String result;
        this.LOG.debug((Object)"Obtaining user profile");
        Profile profile = new Profile();
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(PROFILE_URL);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  http://api.myspace.com/1.0/people/@me/@self", e);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Failed to retrieve the user profile from  http://api.myspace.com/1.0/people/@me/@self. Staus :" + serviceResponse.getStatus());
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("User Profile :" + result));
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read response from  http://api.myspace.com/1.0/people/@me/@self", exc);
        }
        JSONObject pObj = new JSONObject();
        JSONObject jobj = new JSONObject(result);
        if (!jobj.has("person")) {
            throw new ServerDataException("Failed to parse the user profile json : " + result);
        }
        pObj = jobj.getJSONObject("person");
        if (pObj.has("displayName")) {
            profile.setDisplayName(pObj.getString("displayName"));
        }
        if (pObj.has("id")) {
            profile.setValidatedId(pObj.getString("id"));
        }
        if (pObj.has("name")) {
            JSONObject nobj = pObj.getJSONObject("name");
            if (nobj.has("familyName")) {
                profile.setLastName(nobj.getString("familyName"));
            }
            if (nobj.has("givenName")) {
                profile.setFirstName(nobj.getString("givenName"));
            }
        }
        if (pObj.has("location")) {
            profile.setLocation(pObj.getString("location"));
        }
        if (pObj.has("nickname")) {
            profile.setDisplayName(pObj.getString("nickname"));
        }
        if (pObj.has("lang")) {
            profile.setLanguage(pObj.getString("lang"));
        }
        if (pObj.has("thumbnailUrl")) {
            profile.setProfileImageURL(pObj.getString("thumbnailUrl"));
        }
        profile.setProviderId(this.getProviderId());
        this.userProfile = profile;
        return profile;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        return this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessToken != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessToken;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for MySpace");
        throw new SocialAuthException("Update Status is not implemented for MySpace");
    }

    private String getScope() {
        String scopeStr;
        if (Permission.AUTHENTICATE_ONLY.equals(this.scope)) {
            scopeStr = AuthPerms;
        } else if (Permission.CUSTOM.equals(this.scope)) {
            String str = this.config.getCustomPermissions();
            scopeStr = str.replaceAll(",", "|");
        } else {
            scopeStr = AllPerms;
        }
        String pluginScopes = this.getPluginsScope(this.config);
        if (pluginScopes != null) {
            pluginScopes = pluginScopes.replaceAll(",", "|");
            scopeStr = scopeStr + "|" + pluginScopes;
        }
        return scopeStr;
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }

    static {
        ENDPOINTS.put("reqTokenURL", "http://api.myspace.com/request_token");
        ENDPOINTS.put("authorizationURL", "http://api.myspace.com/authorize?myspaceid.permissions=");
        ENDPOINTS.put("accessTokenURL", "http://api.myspace.com/access_token");
    }
}

