/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.oauthstrategy.OAuth1;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.BirthDate;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.XMLParseUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class LinkedInImpl
extends AbstractProvider {
    private static final long serialVersionUID = -6141448721085510813L;
    private static final String CONNECTION_URL = "http://api.linkedin.com/v1/people/~/connections:(id,first-name,last-name,public-profile-url)";
    private static final String UPDATE_STATUS_URL = "http://api.linkedin.com/v1/people/~/shares";
    private static final String PROFILE_URL = "http://api.linkedin.com/v1/people/~:(id,first-name,last-name,languages,date-of-birth,picture-url,email-address,location:(name))";
    private static final String STATUS_BODY = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><share><comment>%1$s</comment><visibility><code>anyone</code></visibility></share>";
    private static final Map<String, String> ENDPOINTS;
    private final Log LOG = LogFactory.getLog(LinkedInImpl.class);
    private Permission scope;
    private AccessGrant accessToken;
    private OAuthConfig config;
    private Profile userProfile;
    private OAuthStrategyBase authenticationStrategy;
    private static final String[] AllPerms;
    private static final String[] AuthPerms;

    public LinkedInImpl(OAuthConfig providerConfig) throws Exception {
        String perms;
        this.config = providerConfig;
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
        if ((perms = this.getScope()) != null) {
            String rURL = ENDPOINTS.get("reqTokenURL");
            rURL = rURL + "?scope=" + perms;
            ENDPOINTS.put("reqTokenURL", rURL);
        }
        this.authenticationStrategy = new OAuth1(this.config, ENDPOINTS);
        this.config.setRequestTokenUrl(ENDPOINTS.get("reqTokenURL"));
        this.config.setAuthenticationUrl(ENDPOINTS.get("authorizationURL"));
        this.config.setAccessTokenUrl(ENDPOINTS.get("accessTokenURL"));
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws Exception {
        this.accessToken = accessGrant;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        this.accessToken = this.authenticationStrategy.verifyResponse(requestParams);
        return this.getProfile();
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        Element root;
        this.LOG.info((Object)"Fetching contacts from http://api.linkedin.com/v1/people/~/connections:(id,first-name,last-name,public-profile-url)");
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(CONNECTION_URL);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to retrieve the contacts from http://api.linkedin.com/v1/people/~/connections:(id,first-name,last-name,public-profile-url)", ie);
        }
        try {
            root = XMLParseUtil.loadXmlResource(serviceResponse.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the contacts from response.http://api.linkedin.com/v1/people/~/connections:(id,first-name,last-name,public-profile-url)", e);
        }
        ArrayList<Contact> contactList = new ArrayList<Contact>();
        if (root != null) {
            NodeList pList = root.getElementsByTagName("person");
            if (pList != null && pList.getLength() > 0) {
                this.LOG.debug((Object)("Found contacts : " + pList.getLength()));
                for (int i = 0; i < pList.getLength(); ++i) {
                    Element p = (Element)pList.item(i);
                    String fname = XMLParseUtil.getElementData(p, "first-name");
                    String lname = XMLParseUtil.getElementData(p, "last-name");
                    String id = XMLParseUtil.getElementData(p, "id");
                    String profileUrl = XMLParseUtil.getElementData(p, "public-profile-url");
                    if (id == null) continue;
                    Contact cont = new Contact();
                    if (fname != null) {
                        cont.setFirstName(fname);
                    }
                    if (lname != null) {
                        cont.setLastName(lname);
                    }
                    if (profileUrl != null) {
                        cont.setProfileUrl(profileUrl);
                    }
                    cont.setId(id);
                    contactList.add(cont);
                }
            } else {
                this.LOG.debug((Object)"No connections were obtained from : http://api.linkedin.com/v1/people/~/connections:(id,first-name,last-name,public-profile-url)");
            }
        }
        return contactList;
    }

    @Override
    public void updateStatus(String msg) throws Exception {
        if (msg == null || msg.trim().length() == 0) {
            throw new ServerDataException("Status cannot be blank");
        }
        if (msg.length() > 700) {
            throw new ServerDataException("Status cannot be more than 700 characters.");
        }
        this.LOG.info((Object)("Updating status " + msg + " on " + UPDATE_STATUS_URL));
        HashMap<String, String> headerParams = new HashMap<String, String>();
        headerParams.put("Content-Type", "text/xml");
        String msgBody = String.format(STATUS_BODY, msg);
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(UPDATE_STATUS_URL, MethodType.POST.toString(), null, headerParams, msgBody);
        }
        catch (Exception ie) {
            throw new SocialAuthException("Failed to update status on http://api.linkedin.com/v1/people/~/shares", ie);
        }
        this.LOG.debug((Object)("Status Updated and return status code is : " + serviceResponse.getStatus()));
    }

    @Override
    public void logout() {
        this.accessToken = null;
        this.authenticationStrategy.logout();
    }

    private Profile getProfile() throws Exception {
        Element root;
        this.LOG.debug((Object)"Obtaining user profile");
        Profile profile = new Profile();
        Response serviceResponse = null;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(PROFILE_URL);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  http://api.linkedin.com/v1/people/~:(id,first-name,last-name,languages,date-of-birth,picture-url,email-address,location:(name))", e);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Failed to retrieve the user profile from  http://api.linkedin.com/v1/people/~:(id,first-name,last-name,languages,date-of-birth,picture-url,email-address,location:(name)). Staus :" + serviceResponse.getStatus());
        }
        try {
            root = XMLParseUtil.loadXmlResource(serviceResponse.getInputStream());
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the profile from response.http://api.linkedin.com/v1/people/~:(id,first-name,last-name,languages,date-of-birth,picture-url,email-address,location:(name))", e);
        }
        if (root != null) {
            Element locationEl;
            String loc;
            NodeList location;
            String email;
            Element dobel;
            String fname = XMLParseUtil.getElementData(root, "first-name");
            String lname = XMLParseUtil.getElementData(root, "last-name");
            NodeList dob = root.getElementsByTagName("date-of-birth");
            if (dob != null && dob.getLength() > 0 && (dobel = (Element)dob.item(0)) != null) {
                String y = XMLParseUtil.getElementData(dobel, "year");
                String m = XMLParseUtil.getElementData(dobel, "month");
                String d = XMLParseUtil.getElementData(dobel, "day");
                BirthDate bd = new BirthDate();
                if (m != null) {
                    bd.setMonth(Integer.parseInt(m));
                }
                if (d != null) {
                    bd.setDay(Integer.parseInt(d));
                }
                if (y != null) {
                    bd.setYear(Integer.parseInt(y));
                }
                profile.setDob(bd);
            }
            String picUrl = XMLParseUtil.getElementData(root, "picture-url");
            String id = XMLParseUtil.getElementData(root, "id");
            if (picUrl != null) {
                profile.setProfileImageURL(picUrl);
            }
            if ((email = XMLParseUtil.getElementData(root, "email-address")) != null) {
                profile.setEmail(email);
            }
            if ((location = root.getElementsByTagName("location")) != null && location.getLength() > 0 && (loc = XMLParseUtil.getElementData(locationEl = (Element)location.item(0), "name")) != null) {
                profile.setLocation(loc);
            }
            profile.setFirstName(fname);
            profile.setLastName(lname);
            profile.setValidatedId(id);
            profile.setProviderId(this.getProviderId());
            this.LOG.debug((Object)("User Profile :" + profile.toString()));
            this.userProfile = profile;
        }
        return profile;
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
        this.authenticationStrategy.setPermission(this.scope);
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        this.LOG.debug((Object)("Calling URL : " + url));
        return this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessToken != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessToken;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for LinkedIn");
        throw new SocialAuthException("Update Image is not implemented for LinkedIn");
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("org.brickred.socialauth.plugin.linkedin.FeedPluginImpl");
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }

    private String getScope() {
        StringBuffer result = new StringBuffer();
        String[] arr = null;
        arr = Permission.AUTHENTICATE_ONLY.equals(this.scope) ? AuthPerms : (Permission.CUSTOM.equals(this.scope) && this.config.getCustomPermissions() != null ? this.config.getCustomPermissions().split(",") : AllPerms);
        result.append(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            result.append(" ").append(arr[i]);
        }
        List<String> scopes = this.config.getPluginsScopes();
        if (scopes != null && !scopes.isEmpty()) {
            String scopesStr = scopes.get(0);
            for (int i = 1; i < scopes.size(); ++i) {
                scopesStr = scopesStr + " " + scopes.get(i);
            }
            result.append(" ").append(scopesStr);
        }
        return result.toString();
    }

    static {
        AllPerms = new String[]{"r_fullprofile", "r_emailaddress", "r_network", "r_contactinfo", "rw_nus"};
        AuthPerms = new String[]{"r_fullprofile", "r_emailaddress"};
        ENDPOINTS = new HashMap<String, String>();
        ENDPOINTS.put("reqTokenURL", "https://api.linkedin.com/uas/oauth/requestToken");
        ENDPOINTS.put("authorizationURL", "https://api.linkedin.com/uas/oauth/authenticate");
        ENDPOINTS.put("accessTokenURL", "https://api.linkedin.com/uas/oauth/accessToken");
    }
}

