/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuth1;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;

public class GenericOAuth1Provider
extends AbstractProvider {
    private static final long serialVersionUID = 1L;
    private final Log LOG = LogFactory.getLog(GenericOAuth1Provider.class);
    private Permission scope;
    private boolean isVerify;
    private AccessGrant accessToken;
    private OAuthConfig config;
    private OAuthStrategyBase authenticationStrategy;
    private final Map<String, String> ENDPOINTS;

    public GenericOAuth1Provider(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        this.ENDPOINTS = new HashMap<String, String>();
        this.ENDPOINTS.put("reqTokenURL", providerConfig.getRequestTokenUrl());
        this.ENDPOINTS.put("authorizationURL", providerConfig.getAuthenticationUrl());
        this.ENDPOINTS.put("accessTokenURL", providerConfig.getAccessTokenUrl());
        this.authenticationStrategy = new OAuth1(this.config, this.ENDPOINTS);
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws Exception {
        this.accessToken = accessGrant;
        this.isVerify = true;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        this.LOG.info((Object)"Determining URL for redirection");
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        if (requestParams.get("denied") != null) {
            throw new UserDeniedPermissionException();
        }
        this.accessToken = this.authenticationStrategy.verifyResponse(requestParams);
        this.isVerify = true;
        return null;
    }

    @Override
    public void logout() {
        this.accessToken = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        Response response = null;
        this.LOG.debug((Object)("Calling URL : " + url));
        response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        return response;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessToken;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    @Override
    public void updateStatus(String msg) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for GenericOauth1Provider");
        throw new SocialAuthException("Update Status is not implemented for GenericOauth1Provider");
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for GenericOauth1Provider");
        throw new SocialAuthException("Get Contacts is not implemented for GenericOauth1Provider");
    }

    @Override
    public Profile getUserProfile() throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for GenericOauth1Provider");
        throw new SocialAuthException("Get Profile is not implemented for GenericOauth1Provider");
    }

    @Override
    public Response uploadImage(String message, String fileName, InputStream inputStream) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for GenericOauth1Provider");
        throw new SocialAuthException("Upload Image is not implemented for GenericOauth1Provider");
    }

    @Override
    protected List<String> getPluginsList() {
        ArrayList<String> list = new ArrayList<String>();
        if (this.config.getRegisteredPlugins() != null && this.config.getRegisteredPlugins().length > 0) {
            list.addAll(Arrays.asList(this.config.getRegisteredPlugins()));
        }
        return list;
    }

    @Override
    protected OAuthStrategyBase getOauthStrategy() {
        return this.authenticationStrategy;
    }
}

