/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.plugin.twitter;

import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Feed;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.plugin.FeedPlugin;
import org.brickred.socialauth.util.ProviderSupport;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class FeedPluginImpl
implements FeedPlugin,
Serializable {
    private static final long serialVersionUID = 5091122799864049766L;
    private static final String FEED_URL = "https://api.twitter.com/1.1/statuses/home_timeline.json";
    private static final DateFormat dateFormat = new SimpleDateFormat("EEE MMM dd hh:mm:ss z yyyy");
    private final Log LOG = LogFactory.getLog(this.getClass());
    private ProviderSupport providerSupport;

    public FeedPluginImpl(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }

    @Override
    public List<Feed> getFeeds() throws Exception {
        Response response = null;
        ArrayList<Feed> list = new ArrayList<Feed>();
        this.LOG.info((Object)"Getting feeds from URL : https://api.twitter.com/1.1/statuses/home_timeline.json");
        try {
            response = this.providerSupport.api(FEED_URL);
            String respStr = response.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("Feeds json string :: " + respStr));
            JSONArray jarr = new JSONArray(respStr);
            this.LOG.debug((Object)("Feeds count :: " + jarr.length()));
            for (int i = 0; i < jarr.length(); ++i) {
                JSONObject jobj = jarr.getJSONObject(i);
                Feed feed = new Feed();
                if (jobj.has("created_at")) {
                    String dateStr = jobj.getString("created_at");
                    feed.setCreatedAt(dateFormat.parse(dateStr));
                }
                if (jobj.has("text")) {
                    feed.setMessage(jobj.getString("text"));
                }
                if (jobj.has("user")) {
                    JSONObject userObj = jobj.getJSONObject("user");
                    if (userObj.has("id_str")) {
                        feed.setId(userObj.getString("id_str"));
                    }
                    if (userObj.has("name")) {
                        feed.setFrom(userObj.getString("name"));
                    }
                    if (userObj.has("screen_name")) {
                        feed.setScreenName(userObj.getString("screen_name"));
                    }
                }
                list.add(feed);
            }
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting feeds from https://api.twitter.com/1.1/statuses/home_timeline.json", e);
        }
        return list;
    }

    @Override
    public ProviderSupport getProviderSupport() {
        return this.providerSupport;
    }

    @Override
    public void setProviderSupport(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }
}

