/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.plugin.twitter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Album;
import org.brickred.socialauth.Photo;
import org.brickred.socialauth.plugin.AlbumsPlugin;
import org.brickred.socialauth.util.ProviderSupport;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class AlbumsPluginImpl
implements AlbumsPlugin,
Serializable {
    private static final long serialVersionUID = -4810906169491380470L;
    private static final String FEED_URL = "https://api.twitter.com/1.1/statuses/home_timeline.json?include_entities=true&count=100";
    private final Log LOG = LogFactory.getLog(this.getClass());
    private static HashMap<String, List<Photo>> photo_data = new HashMap();
    private ProviderSupport providerSupport;

    public AlbumsPluginImpl(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }

    @Override
    public List<Album> getAlbums() throws Exception {
        Response response = null;
        ArrayList<Album> albums = new ArrayList<Album>();
        this.LOG.info((Object)"Getting feeds from URL : https://api.twitter.com/1.1/statuses/home_timeline.json?include_entities=true&count=100");
        response = this.providerSupport.api(FEED_URL);
        String respStr = response.getResponseBodyAsString("UTF-8");
        this.LOG.debug((Object)("Feeds json string :: " + respStr));
        JSONArray jarr = new JSONArray(respStr);
        this.LOG.debug((Object)("Feeds count :: " + jarr.length()));
        for (int i = 0; i < jarr.length(); ++i) {
            JSONObject mediaObj;
            JSONObject entitiesObj;
            Album album = new Album();
            JSONObject jobj = jarr.getJSONObject(i);
            if (!jobj.has("user")) continue;
            JSONObject userObj = jobj.getJSONObject("user");
            if (!jobj.has("entities") || !(entitiesObj = jobj.getJSONObject("entities")).has("media") || !(mediaObj = entitiesObj.getJSONArray("media").getJSONObject(0)).has("type") || !mediaObj.getString("type").equalsIgnoreCase("photo") || !userObj.has("name") || !mediaObj.has("media_url")) continue;
            List<Photo> photos = photo_data.get(userObj.getString("name"));
            if (photos == null) {
                photos = new ArrayList<Photo>();
                photo_data.put(userObj.getString("name"), photos);
                album.setName(userObj.getString("name"));
                album.setCoverPhoto(userObj.getString("profile_image_url").replaceAll("_normal", "_reasonably_small"));
                albums.add(album);
            }
            Photo photo = new Photo();
            String photoURL = mediaObj.getString("media_url");
            photo.setThumbImage(photoURL + ":thumb");
            photo.setSmallImage(photoURL + ":small");
            photo.setMediumImage(photoURL);
            photo.setLargeImage(photoURL + ":large");
            if (jobj.has("text")) {
                photo.setTitle(jobj.getString("text"));
            }
            if (mediaObj.has("id_str")) {
                photo.setId(mediaObj.getString("id_str"));
            }
            if (mediaObj.has("expanded_url")) {
                photo.setLink(mediaObj.getString("expanded_url"));
            }
            if (jobj.has("retweet_count")) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("retweet_count", String.valueOf(jobj.getInt("retweet_count")));
                photo.setMetaData(map);
            }
            photos.add(photo);
        }
        for (Album album : albums) {
            List<Photo> photos = photo_data.get(album.getName());
            album.setPhotos(photos);
            album.setPhotosCount(photos.size());
        }
        return albums;
    }

    @Override
    public ProviderSupport getProviderSupport() {
        return this.providerSupport;
    }

    @Override
    public void setProviderSupport(ProviderSupport providerSupport) {
        this.providerSupport = providerSupport;
    }
}

