/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.exception.SocialAuthConfigurationException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.provider.FacebookImpl;
import org.brickred.socialauth.provider.FourSquareImpl;
import org.brickred.socialauth.provider.GoogleImpl;
import org.brickred.socialauth.provider.HotmailImpl;
import org.brickred.socialauth.provider.LinkedInImpl;
import org.brickred.socialauth.provider.MendeleyImpl;
import org.brickred.socialauth.provider.MySpaceImpl;
import org.brickred.socialauth.provider.OpenIdImpl;
import org.brickred.socialauth.provider.RunkeeperImpl;
import org.brickred.socialauth.provider.SalesForceImpl;
import org.brickred.socialauth.provider.TwitterImpl;
import org.brickred.socialauth.provider.YahooImpl;
import org.brickred.socialauth.provider.YammerImpl;
import org.brickred.socialauth.util.HttpUtil;
import org.brickred.socialauth.util.OAuthConfig;

public class SocialAuthConfig
implements Serializable {
    private static final long serialVersionUID = 1298666003842985895L;
    private static final String OAUTH_CONSUMER_PROPS = "oauth_consumer.properties";
    private Map<String, Class<?>> providersImplMap = new HashMap();
    private Map<String, OAuthConfig> providersConfig;
    private Properties applicationProperties;
    private Map<String, String> domainMap;
    private boolean configSetup;
    private static final Log LOG = LogFactory.getLog(SocialAuthConfig.class);
    private static SocialAuthConfig DEFAULT = new SocialAuthConfig();
    private boolean isConfigLoaded;

    public static SocialAuthConfig getDefault() {
        return DEFAULT;
    }

    public SocialAuthConfig() {
        this.providersImplMap.put("facebook", FacebookImpl.class);
        this.providersImplMap.put("foursquare", FourSquareImpl.class);
        this.providersImplMap.put("google", GoogleImpl.class);
        this.providersImplMap.put("hotmail", HotmailImpl.class);
        this.providersImplMap.put("linkedin", LinkedInImpl.class);
        this.providersImplMap.put("myspace", MySpaceImpl.class);
        this.providersImplMap.put("openid", OpenIdImpl.class);
        this.providersImplMap.put("twitter", TwitterImpl.class);
        this.providersImplMap.put("yahoo", YahooImpl.class);
        this.providersImplMap.put("salesforce", SalesForceImpl.class);
        this.providersImplMap.put("yammer", YammerImpl.class);
        this.providersImplMap.put("mendeley", MendeleyImpl.class);
        this.providersImplMap.put("runkeeper", RunkeeperImpl.class);
        this.domainMap = new HashMap<String, String>();
        this.domainMap.put("google", "www.google.com");
        this.domainMap.put("yahoo", "api.login.yahoo.com");
        this.domainMap.put("twitter", "twitter.com");
        this.domainMap.put("facebook", "graph.facebook.com");
        this.domainMap.put("hotmail", "consent.live.com");
        this.domainMap.put("linkedin", "api.linkedin.com");
        this.domainMap.put("foursquare", "foursquare.com");
        this.domainMap.put("myspace", "api.myspace.com");
        this.domainMap.put("salesforce", "login.salesforce.com");
        this.domainMap.put("yammer", "www.yammer.com");
        this.domainMap.put("mendeley", "api.mendeley.com");
        this.domainMap.put("runkeeper", "runkeeper.com");
        this.providersConfig = new HashMap<String, OAuthConfig>();
        OAuthConfig c = new OAuthConfig("openid", "openid");
        c.setProviderImplClass(OpenIdImpl.class);
        this.providersConfig.put("openid", c);
    }

    private void registerProviders() throws Exception {
        for (Object key : this.applicationProperties.keySet()) {
            String str = key.toString();
            if (!str.startsWith("socialauth.")) continue;
            String val = str.substring("socialauth.".length());
            this.providersImplMap.put(val, Class.forName(this.applicationProperties.get(str).toString()));
            this.domainMap.put(val, val);
        }
    }

    public void addProvider(String pname, Class<?> clazz) throws Exception {
        LOG.debug((Object)("Registering a provider " + pname));
        this.providersImplMap.put(pname, clazz);
    }

    public Properties getApplicationProperties() {
        return this.applicationProperties;
    }

    public void setApplicationProperties(Properties applicationProperties) throws Exception {
        LOG.info((Object)"Loading application properties");
        this.applicationProperties = applicationProperties;
        this.load(this.applicationProperties);
    }

    public void load(InputStream inputStream) throws Exception {
        if (!this.isConfigLoaded) {
            LOG.debug((Object)"Loading application configuration through input stream.");
            Properties props = new Properties();
            try {
                props.load(inputStream);
                this.load(props);
            }
            catch (IOException ie) {
                throw new IOException("Could not load configuration from input stream");
            }
        }
    }

    public void load(Properties properties) throws Exception {
        if (!this.isConfigLoaded) {
            LOG.info((Object)"Loading application configuration");
            LOG.debug((Object)("Loading application configuration through properties. Given properties are :" + properties));
            this.applicationProperties = properties;
            this.registerProviders();
            this.loadProvidersConfig();
            this.setProxy();
            String timeout = null;
            if (this.applicationProperties.containsKey("http.connectionTimeOut")) {
                timeout = this.applicationProperties.getProperty("http.connectionTimeOut").trim();
            }
            if (timeout != null && !timeout.isEmpty()) {
                int time = 0;
                try {
                    time = Integer.parseInt(timeout);
                }
                catch (NumberFormatException ne) {
                    LOG.warn((Object)"Http connection timout is not an integer in configuration");
                }
                HttpUtil.setConnectionTimeout(time);
            }
            this.isConfigLoaded = true;
        }
    }

    public void load(String fileName) throws Exception {
        if (!this.isConfigLoaded) {
            LOG.debug((Object)("Loading application configuration from file " + fileName));
            ClassLoader loader = SocialAuthConfig.class.getClassLoader();
            try {
                InputStream in = loader.getResourceAsStream(fileName);
                this.load(in);
            }
            catch (NullPointerException ne) {
                throw new FileNotFoundException(fileName + " file is not found in your class path");
            }
        }
    }

    public void load() throws Exception {
        if (!this.isConfigLoaded) {
            LOG.debug((Object)"Loading application configuration from file oauth_consumer.properties");
            this.load(OAUTH_CONSUMER_PROPS);
        }
    }

    public void addProviderConfig(String providerId, OAuthConfig config) throws Exception {
        config.setId(providerId);
        LOG.debug((Object)("Adding provider configuration :" + config));
        this.providersConfig.put(providerId, config);
        if (!this.providersImplMap.containsKey(providerId) && config.getProviderImplClass() != null) {
            this.providersImplMap.put(providerId, config.getProviderImplClass());
            this.domainMap.put(providerId, providerId);
        }
    }

    private void loadProvidersConfig() {
        for (Map.Entry<String, String> entry : this.domainMap.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String cKey = this.applicationProperties.getProperty(value + ".consumer_key");
            String cSecret = this.applicationProperties.getProperty(value + ".consumer_secret");
            if (cKey != null && cSecret != null) {
                String[] plugins;
                String pluginsStr;
                String tokenUrl;
                String authUrl;
                String reqUrl;
                String perms;
                LOG.debug((Object)("Loading configuration for provider : " + key));
                OAuthConfig conf = new OAuthConfig(cKey, cSecret);
                conf.setId(key);
                conf.setProviderImplClass(this.providersImplMap.get(key));
                if (this.applicationProperties.containsKey(value + ".custom_permissions") && (perms = this.applicationProperties.getProperty(value + ".custom_permissions").trim()).length() > 0) {
                    conf.setCustomPermissions(perms);
                }
                if (this.applicationProperties.containsKey(value + ".request_token_url") && (reqUrl = this.applicationProperties.getProperty(value + ".request_token_url").trim()).length() > 0) {
                    conf.setRequestTokenUrl(reqUrl);
                }
                if (this.applicationProperties.containsKey(value + ".authentication_url") && (authUrl = this.applicationProperties.getProperty(value + ".authentication_url").trim()).length() > 0) {
                    conf.setAuthenticationUrl(authUrl);
                }
                if (this.applicationProperties.containsKey(value + ".access_token_url") && (tokenUrl = this.applicationProperties.getProperty(value + ".access_token_url").trim()).length() > 0) {
                    conf.setAccessTokenUrl(tokenUrl);
                }
                if (this.applicationProperties.containsKey(value + ".plugins") && (pluginsStr = this.applicationProperties.getProperty(value + ".plugins").trim()).length() > 0 && (plugins = pluginsStr.split(",")).length > 0) {
                    ArrayList<String> pluginScopes = new ArrayList<String>();
                    conf.setRegisteredPlugins(plugins);
                    for (String plugin : plugins) {
                        String pscope;
                        if (!this.applicationProperties.containsKey(plugin + ".scope") || (pscope = this.applicationProperties.getProperty(plugin + ".scope").trim()).length() <= 0) continue;
                        String[] sarr = pscope.split(",");
                        pluginScopes.addAll(Arrays.asList(sarr));
                    }
                    if (!pluginScopes.isEmpty()) {
                        conf.setPluginsScopes(pluginScopes);
                    }
                }
                this.providersConfig.put(key, conf);
                continue;
            }
            LOG.debug((Object)("Configuration for provider " + key + " is not available"));
        }
        this.configSetup = true;
    }

    public OAuthConfig getProviderConfig(String id) throws Exception {
        OAuthConfig config = this.providersConfig.get(id);
        if (config == null) {
            try {
                new URL(id);
                config = this.getProviderConfig("openid");
                if (config != null) {
                    config.setId(id);
                }
            }
            catch (MalformedURLException me) {
                throw new SocialAuthException(id + " is not a provider or valid OpenId URL");
            }
        }
        if (config == null) {
            throw new SocialAuthConfigurationException("Configuration of " + id + " provider is not found");
        }
        if (config.get_consumerSecret().length() <= 0) {
            throw new SocialAuthConfigurationException(id + " consumer_secret value is null");
        }
        if (config.get_consumerKey().length() <= 0) {
            throw new SocialAuthConfigurationException(id + " consumer_key value is null");
        }
        return config;
    }

    protected boolean isConfigSetup() {
        return this.configSetup;
    }

    private void setProxy() {
        String proxyHost = null;
        String proxyPort = null;
        if (this.applicationProperties.containsKey("proxy.host")) {
            proxyHost = this.applicationProperties.getProperty("proxy.host").trim();
        }
        if (this.applicationProperties.containsKey("proxy.port")) {
            proxyPort = this.applicationProperties.getProperty("proxy.port").trim();
        }
        if (proxyHost != null && !proxyHost.isEmpty()) {
            int port = 0;
            if (proxyPort != null && !proxyPort.isEmpty()) {
                try {
                    port = Integer.parseInt(proxyPort);
                }
                catch (NumberFormatException ne) {
                    LOG.warn((Object)"Proxy port is not an integer in configuration");
                }
            }
            HttpUtil.setProxyConfig(proxyHost, port);
        }
    }
}

