/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.plugin.Plugin;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.ProviderSupport;

public abstract class AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = -7827145708317886744L;
    private Map<Class<? extends Plugin>, Class<? extends Plugin>> pluginsMap;
    private final Log LOG = LogFactory.getLog(this.getClass());

    public AbstractProvider() throws Exception {
        this.pluginsMap = new HashMap<Class<? extends Plugin>, Class<? extends Plugin>>();
    }

    @Override
    public <T> T getPlugin(Class<T> clazz) throws Exception {
        Class<? extends Plugin> plugin = this.pluginsMap.get(clazz);
        Constructor<? extends Plugin> cons = plugin.getConstructor(ProviderSupport.class);
        ProviderSupport support = new ProviderSupport(this.getOauthStrategy());
        Plugin obj = cons.newInstance(support);
        return (T)obj;
    }

    @Override
    public boolean isSupportedPlugin(Class<? extends Plugin> clazz) {
        return this.pluginsMap.containsKey(clazz);
    }

    @Override
    public final void registerPlugins() throws Exception {
        this.LOG.info((Object)"Loading plugins");
        List<String> pluginsList = this.getPluginsList();
        if (pluginsList != null && !pluginsList.isEmpty()) {
            for (String s : pluginsList) {
                Class<?>[] interfaces;
                this.LOG.info((Object)("Loading plugin :: " + s));
                Class<Plugin> clazz = Class.forName(s).asSubclass(Plugin.class);
                Constructor<Plugin> cons = clazz.getConstructor(ProviderSupport.class);
                for (Class<?> c : interfaces = clazz.getInterfaces()) {
                    if (!Plugin.class.isAssignableFrom(c)) continue;
                    this.pluginsMap.put(c.asSubclass(Plugin.class), clazz);
                }
            }
        }
    }

    public String getPluginsScope(OAuthConfig oauthConfig) {
        List<String> scopes = oauthConfig.getPluginsScopes();
        if (scopes != null && !scopes.isEmpty()) {
            String scopesStr = scopes.get(0);
            for (int i = 1; i < scopes.size(); ++i) {
                scopesStr = scopesStr + "," + scopes.get(i);
            }
            return scopesStr;
        }
        return null;
    }

    protected abstract List<String> getPluginsList();

    protected abstract OAuthStrategyBase getOauthStrategy();
}

