/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuth2;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.BirthDate;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.SocialAuthUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class HotmailImpl
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = 4559561466129062485L;
    private static final String PROFILE_URL = "https://apis.live.net/v5.0/me";
    private static final String CONTACTS_URL = "https://apis.live.net/v5.0/me/contacts";
    private static final String UPDATE_STATUS_URL = "https://apis.live.net/v5.0/me/share";
    private static final String PROFILE_PICTURE_URL = "https://apis.live.net/v5.0/me/picture?access_token=%1$s";
    private static final Map<String, String> ENDPOINTS;
    private final Log LOG = LogFactory.getLog(HotmailImpl.class);
    private Permission scope;
    private boolean isVerify;
    private OAuthConfig config;
    private Profile userProfile;
    private AccessGrant accessGrant;
    private OAuthStrategyBase authenticationStrategy;
    private static final String AllPerms;
    private static final String AuthenticateOnlyPerms;

    public HotmailImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
        this.authenticationStrategy = new OAuth2(this.config, ENDPOINTS);
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws Exception {
        this.accessGrant = accessGrant;
        this.scope = accessGrant.getPermission();
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(HttpServletRequest request) throws Exception {
        Map<String, String> params = SocialAuthUtil.getRequestParametersMap(request);
        return this.doVerifyResponse(params);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Retrieving Access Token in verify response function");
        if (requestParams.get("wrap_error_reason") != null && "user_denied".equals(requestParams.get("wrap_error_reason"))) {
            throw new UserDeniedPermissionException();
        }
        this.accessGrant = this.authenticationStrategy.verifyResponse(requestParams);
        if (this.accessGrant != null) {
            this.isVerify = true;
            System.out.println(this.accessGrant.toString());
            this.LOG.debug((Object)"Obtaining user profile");
            return this.getProfile();
        }
        throw new SocialAuthException("Unable to get Access token");
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        if (Permission.AUTHENTICATE_ONLY.equals(this.scope)) {
            throw new SocialAuthException("You have not set permission to get contacts");
        }
        this.LOG.info((Object)"Fetching contacts from https://apis.live.net/v5.0/me/contacts");
        return this.getContacts(CONTACTS_URL);
    }

    private List<Contact> getContacts(String url) throws Exception {
        String result;
        Response serviceResponse;
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(url);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting contacts from " + url, e);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Error while getting contacts from " + url + "Status : " + serviceResponse.getStatus());
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to get response from " + url, e);
        }
        this.LOG.debug((Object)("User Contacts list in JSON " + result));
        JSONObject resp = new JSONObject(result);
        ArrayList<Contact> plist = new ArrayList<Contact>();
        if (resp.has("data")) {
            JSONArray addArr = resp.getJSONArray("data");
            this.LOG.debug((Object)("Contacts Found : " + addArr.length()));
            for (int i = 0; i < addArr.length(); ++i) {
                JSONArray emailArr;
                JSONObject obj = addArr.getJSONObject(i);
                Contact p = new Contact();
                if (obj.has("email_hashes") && (emailArr = obj.getJSONArray("email_hashes")).length() > 0) {
                    p.setEmailHash(emailArr.getString(0));
                }
                if (obj.has("name")) {
                    p.setDisplayName(obj.getString("name"));
                }
                if (obj.has("first_name")) {
                    p.setFirstName(obj.getString("first_name"));
                }
                if (obj.has("last_name")) {
                    p.setLastName(obj.getString("last_name"));
                }
                if (obj.has("id")) {
                    p.setId(obj.getString("id"));
                }
                plist.add(p);
            }
        }
        serviceResponse.close();
        return plist;
    }

    @Override
    public void updateStatus(String msg) throws Exception {
        this.LOG.info((Object)("Updating status : " + msg));
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        if (msg == null || msg.trim().length() == 0) {
            throw new ServerDataException("Status cannot be blank");
        }
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put("Authorization", "Bearer " + this.accessGrant.getKey());
        headerParam.put("Content-Type", "application/json");
        String body = "{message:\"" + msg + "\"}";
        Response serviceResponse = this.authenticationStrategy.executeFeed(UPDATE_STATUS_URL, MethodType.POST.toString(), null, headerParam, body);
        int code = serviceResponse.getStatus();
        this.LOG.debug((Object)("Status updated and return status code is :" + code));
        serviceResponse.close();
    }

    @Override
    public void logout() {
        this.accessGrant = null;
        this.authenticationStrategy.logout();
    }

    private Profile getProfile() throws Exception {
        String result;
        Response serviceResponse;
        Profile p = new Profile();
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(PROFILE_URL);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  https://apis.live.net/v5.0/me", e);
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("User Profile :" + result));
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to read response from  https://apis.live.net/v5.0/me", e);
        }
        try {
            JSONObject resp = new JSONObject(result);
            if (resp.has("Id")) {
                p.setValidatedId(resp.getString("Id"));
            }
            if (resp.has("name")) {
                p.setFullName(resp.getString("name"));
            }
            if (resp.has("first_name")) {
                p.setFirstName(resp.getString("first_name"));
            }
            if (resp.has("last_name")) {
                p.setLastName(resp.getString("last_name"));
            }
            if (resp.has("Location")) {
                p.setLocation(resp.getString("Location"));
            }
            if (resp.has("gender")) {
                p.setGender(resp.getString("gender"));
            }
            if (resp.has("ThumbnailImageLink")) {
                p.setProfileImageURL(resp.getString("ThumbnailImageLink"));
            }
            if (resp.has("birth_day")) {
                BirthDate bd = new BirthDate();
                bd.setDay(resp.getInt("birth_day"));
                if (resp.has("birth_month")) {
                    bd.setMonth(resp.getInt("birth_month"));
                }
                if (resp.has("birth_year")) {
                    bd.setYear(resp.getInt("birth_year"));
                }
                p.setDob(bd);
            }
            if (resp.has("emails")) {
                JSONObject eobj = resp.getJSONObject("emails");
                String email = null;
                if (eobj.has("preferred")) {
                    email = eobj.getString("preferred");
                }
                if ((email == null || email.isEmpty()) && eobj.has("account")) {
                    email = eobj.getString("account");
                }
                if ((email == null || email.isEmpty()) && eobj.has("personal")) {
                    email = eobj.getString("personal");
                }
                p.setEmail(email);
            }
            if (resp.has("locale")) {
                p.setLanguage(resp.getString("locale"));
            }
            serviceResponse.close();
            p.setProviderId(this.getProviderId());
            String picUrl = String.format(PROFILE_PICTURE_URL, this.accessGrant.getKey());
            p.setProfileImageURL(picUrl);
            this.userProfile = p;
            return p;
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to parse the user profile json : " + result, e);
        }
    }

    @Override
    public void setPermission(Permission p) {
        this.scope = p;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        Response serviceResponse;
        this.LOG.debug((Object)("Calling URL : " + url));
        try {
            serviceResponse = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while making request to URL : " + url, e);
        }
        if (serviceResponse.getStatus() != 200) {
            this.LOG.debug((Object)("Return statuc for URL " + url + " is " + serviceResponse.getStatus()));
            throw new SocialAuthException("Error while making request to URL :" + url + "Status : " + serviceResponse.getStatus());
        }
        return serviceResponse;
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessGrant != null) {
            this.getProfile();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessGrant;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    private String getScope() {
        String scopeStr = null;
        scopeStr = Permission.AUTHENTICATE_ONLY.equals(this.scope) ? AuthenticateOnlyPerms : (Permission.CUSTOM.equals(this.scope) ? this.config.getCustomPermissions() : AllPerms);
        return scopeStr;
    }

    static {
        AllPerms = new String("wl.basic,wl.emails,wl.share,wl.birthday");
        AuthenticateOnlyPerms = new String("wl.basic,wl.emails");
        ENDPOINTS = new HashMap<String, String>();
        ENDPOINTS.put("authorizationURL", "https://oauth.live.com/authorize");
        ENDPOINTS.put("accessTokenURL", "https://oauth.live.com/token");
    }
}

