/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.oauthstrategy.OAuth2;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.BirthDate;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.brickred.socialauth.util.SocialAuthUtil;
import org.json.JSONArray;
import org.json.JSONObject;

public class FacebookImpl
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = 8644510564735754296L;
    private static final String PROFILE_URL = "https://graph.facebook.com/me";
    private static final String CONTACTS_URL = "https://graph.facebook.com/me/friends";
    private static final String UPDATE_STATUS_URL = "https://graph.facebook.com/me/feed";
    private static final String PROFILE_IMAGE_URL = "http://graph.facebook.com/%1$s/picture";
    private static final String PUBLIC_PROFILE_URL = "http://www.facebook.com/profile.php?id=";
    private static final Map<String, String> ENDPOINTS;
    private final Log LOG = LogFactory.getLog(FacebookImpl.class);
    private Permission scope;
    private OAuthConfig config;
    private Profile userProfile;
    private AccessGrant accessGrant;
    private OAuthStrategyBase authenticationStrategy;
    private static final String[] AllPerms;
    private static final String[] AuthPerms;

    public FacebookImpl(OAuthConfig providerConfig) throws Exception {
        this.config = providerConfig;
        if (this.config.getCustomPermissions() != null) {
            this.scope = Permission.CUSTOM;
        }
        this.authenticationStrategy = new OAuth2(this.config, ENDPOINTS);
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) throws Exception {
        this.accessGrant = accessGrant;
        this.authenticationStrategy.setAccessGrant(accessGrant);
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        return this.authenticationStrategy.getLoginRedirectURL(successUrl);
    }

    @Override
    public Profile verifyResponse(HttpServletRequest httpReq) throws Exception {
        Map<String, String> params = SocialAuthUtil.getRequestParametersMap(httpReq);
        return this.doVerifyResponse(params);
    }

    @Override
    public Profile verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.doVerifyResponse(requestParams);
    }

    private Profile doVerifyResponse(Map<String, String> requestParams) throws Exception {
        this.LOG.info((Object)"Retrieving Access Token in verify response function");
        if (requestParams.get("error_reason") != null && "user_denied".equals(requestParams.get("error_reason"))) {
            throw new UserDeniedPermissionException();
        }
        this.accessGrant = this.authenticationStrategy.verifyResponse(requestParams);
        if (this.accessGrant != null) {
            this.LOG.debug((Object)"Obtaining user profile");
            return this.authFacebookLogin();
        }
        throw new SocialAuthException("Access token not found");
    }

    private Profile authFacebookLogin() throws Exception {
        String presp;
        try {
            Response response = this.authenticationStrategy.executeFeed(PROFILE_URL);
            presp = response.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting profile from https://graph.facebook.com/me", e);
        }
        try {
            this.LOG.debug((Object)("User Profile : " + presp));
            JSONObject resp = new JSONObject(presp);
            Profile p = new Profile();
            p.setValidatedId(resp.getString("id"));
            p.setFirstName(resp.getString("first_name"));
            p.setLastName(resp.getString("last_name"));
            p.setEmail(resp.getString("email"));
            if (resp.has("location")) {
                p.setLocation(resp.getJSONObject("location").getString("name"));
            }
            if (resp.has("birthday")) {
                String bstr = resp.getString("birthday");
                String[] arr = bstr.split("/");
                BirthDate bd = new BirthDate();
                if (arr.length > 0) {
                    bd.setMonth(Integer.parseInt(arr[0]));
                }
                if (arr.length > 1) {
                    bd.setDay(Integer.parseInt(arr[1]));
                }
                if (arr.length > 2) {
                    bd.setYear(Integer.parseInt(arr[2]));
                }
                p.setDob(bd);
            }
            if (resp.has("gender")) {
                p.setGender(resp.getString("gender"));
            }
            p.setProfileImageURL(String.format(PROFILE_IMAGE_URL, resp.getString("id")));
            String locale = resp.getString("locale");
            if (locale != null) {
                String[] a = locale.split("_");
                p.setLanguage(a[0]);
                p.setCountry(a[1]);
            }
            p.setProviderId(this.getProviderId());
            this.userProfile = p;
            return p;
        }
        catch (Exception ex) {
            throw new ServerDataException("Failed to parse the user profile json : " + presp, ex);
        }
    }

    @Override
    public void updateStatus(String msg) throws Exception {
        this.LOG.info((Object)("Updating status : " + msg));
        if (msg == null || msg.trim().length() == 0) {
            throw new ServerDataException("Status cannot be blank");
        }
        StringBuilder strb = new StringBuilder();
        strb.append("message=").append(msg);
        strb.append("&access_token").append("=").append(this.accessGrant.getKey());
        try {
            Response serviceResponse = this.authenticationStrategy.executeFeed(UPDATE_STATUS_URL, MethodType.POST.toString(), null, null, strb.toString());
            if (serviceResponse.getStatus() != 200) {
                throw new SocialAuthException("Status not updated. Return Status code :" + serviceResponse.getStatus());
            }
        }
        catch (Exception e) {
            throw new SocialAuthException(e);
        }
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        String respStr;
        ArrayList<Contact> plist = new ArrayList<Contact>();
        this.LOG.info((Object)"Fetching contacts from https://graph.facebook.com/me/friends");
        try {
            Response response = this.authenticationStrategy.executeFeed(CONTACTS_URL);
            respStr = response.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting contacts from https://graph.facebook.com/me/friends", e);
        }
        try {
            this.LOG.debug((Object)("User Contacts list in json : " + respStr));
            JSONObject resp = new JSONObject(respStr);
            JSONArray data = resp.getJSONArray("data");
            this.LOG.debug((Object)("Found contacts : " + data.length()));
            for (int i = 0; i < data.length(); ++i) {
                JSONObject obj = data.getJSONObject(i);
                Contact p = new Contact();
                String name = obj.getString("name");
                if (name != null) {
                    String[] nameArr = name.split(" ");
                    if (nameArr.length > 1) {
                        p.setFirstName(nameArr[0]);
                        p.setLastName(nameArr[1]);
                    } else {
                        p.setFirstName(obj.getString("name"));
                    }
                    p.setDisplayName(name);
                }
                p.setId(obj.getString("id"));
                p.setProfileUrl(PUBLIC_PROFILE_URL + obj.getString("id"));
                plist.add(p);
            }
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the user profile json : " + respStr, e);
        }
        return plist;
    }

    @Override
    public void logout() {
        this.accessGrant = null;
        this.authenticationStrategy.logout();
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
        this.authenticationStrategy.setPermission(this.scope);
        this.authenticationStrategy.setScope(this.getScope());
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        this.LOG.info((Object)("Calling api function for url\t:\t" + url));
        Response response = null;
        try {
            response = this.authenticationStrategy.executeFeed(url, methodType, params, headerParams, body);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while making request to URL : " + url, e);
        }
        return response;
    }

    @Override
    public Profile getUserProfile() throws Exception {
        if (this.userProfile == null && this.accessGrant != null) {
            this.authFacebookLogin();
        }
        return this.userProfile;
    }

    @Override
    public AccessGrant getAccessGrant() {
        return this.accessGrant;
    }

    @Override
    public String getProviderId() {
        return this.config.getId();
    }

    private String getScope() {
        StringBuffer result = new StringBuffer();
        String[] arr = null;
        arr = Permission.AUTHENTICATE_ONLY.equals(this.scope) ? AuthPerms : (Permission.CUSTOM.equals(this.scope) && this.config.getCustomPermissions() != null ? this.config.getCustomPermissions().split(",") : AllPerms);
        result.append(arr[0]);
        for (int i = 1; i < arr.length; ++i) {
            result.append(",").append(arr[i]);
        }
        return result.toString();
    }

    static {
        AllPerms = new String[]{"publish_stream", "email", "user_birthday", "user_location"};
        AuthPerms = new String[]{"email", "user_birthday", "user_location"};
        ENDPOINTS = new HashMap<String, String>();
        ENDPOINTS.put("authorizationURL", "https://graph.facebook.com/oauth/authorize");
        ENDPOINTS.put("accessTokenURL", "https://graph.facebook.com/oauth/access_token");
    }
}

