/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.oauthstrategy;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.exception.ProviderStateException;
import org.brickred.socialauth.exception.SocialAuthConfigurationException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.oauthstrategy.OAuthStrategyBase;
import org.brickred.socialauth.util.AccessGrant;
import org.brickred.socialauth.util.HttpUtil;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.OAuthConsumer;
import org.brickred.socialauth.util.OpenIdConsumer;
import org.brickred.socialauth.util.Response;

public class Hybrid
implements OAuthStrategyBase {
    private static final long serialVersionUID = -1331047094086589944L;
    private final Log LOG = LogFactory.getLog(Hybrid.class);
    private AccessGrant requestToken;
    private AccessGrant accessToken;
    private Map<String, String> endpoints;
    private String scope;
    private Permission permission;
    private String providerId;
    private OAuthConsumer oauth;
    private boolean providerState;

    public Hybrid(OAuthConfig config, Map<String, String> endpoints) {
        this.oauth = new OAuthConsumer(config);
        this.endpoints = endpoints;
        this.permission = Permission.DEFAULT;
        this.providerId = config.getId();
    }

    @Override
    public String getLoginRedirectURL(String successUrl) throws Exception {
        String associationURL = OpenIdConsumer.getAssociationURL(this.endpoints.get("reqTokenURL"));
        Response r = HttpUtil.doHttpRequest(associationURL, MethodType.GET.toString(), null, null);
        StringBuffer sb = new StringBuffer();
        String assocHandle = "";
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(r.getInputStream(), "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line).append("\n");
                if (!"assoc_handle:".equals(line.substring(0, 13))) continue;
                assocHandle = line.substring(13);
                break;
            }
            this.LOG.debug((Object)("ASSOCCIATION : " + assocHandle));
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read response from  ");
        }
        String realm = successUrl.substring(0, successUrl.indexOf("/", 9));
        String consumerURL = realm.replace("http://", "");
        consumerURL = consumerURL.replace("https://", "");
        consumerURL = consumerURL.replaceAll(":{1}\\d*", "");
        this.providerState = true;
        String url = OpenIdConsumer.getRequestTokenURL(this.endpoints.get("reqTokenURL"), successUrl, realm, assocHandle, consumerURL, this.scope);
        this.LOG.info((Object)("Redirection to following URL should happen : " + url));
        return url;
    }

    @Override
    public AccessGrant verifyResponse(Map<String, String> requestParams) throws Exception {
        return this.verifyResponse(requestParams, MethodType.GET.toString());
    }

    @Override
    public AccessGrant verifyResponse(Map<String, String> requestParams, String methodType) throws Exception {
        if (!this.providerState) {
            throw new ProviderStateException();
        }
        this.LOG.debug((Object)"Running OpenID discovery");
        String reqTokenStr = "";
        if (Permission.AUTHENTICATE_ONLY.equals(this.permission)) {
            this.accessToken = new AccessGrant();
        } else {
            if (requestParams.get("openid.ext2.request_token") != null) {
                reqTokenStr = HttpUtil.decodeURIComponent(requestParams.get("openid.ext2.request_token"));
            }
            this.requestToken = new AccessGrant();
            this.requestToken.setKey(reqTokenStr);
            this.LOG.debug((Object)"Call to fetch Access Token");
            this.accessToken = this.oauth.getAccessToken(this.endpoints.get("accessTokenURL"), this.requestToken);
            if (this.accessToken == null) {
                throw new SocialAuthConfigurationException("Application keys may not be correct. The server running the application should be same that was registered to get the keys.");
            }
        }
        for (Map.Entry<String, String> entry : requestParams.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            this.accessToken.setAttribute(key, value);
        }
        if (this.permission != null) {
            this.accessToken.setPermission(this.permission);
        } else {
            this.accessToken.setPermission(Permission.DEFAULT);
        }
        this.accessToken.setProviderId(this.providerId);
        return this.accessToken;
    }

    @Override
    public Response executeFeed(String url) throws Exception {
        if (this.accessToken == null) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        return this.oauth.httpGet(url, null, this.accessToken);
    }

    @Override
    public Response executeFeed(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        Response response = null;
        if (this.accessToken == null) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        if (MethodType.GET.toString().equals(methodType)) {
            try {
                response = this.oauth.httpGet(url, headerParams, this.accessToken);
            }
            catch (Exception ie) {
                throw new SocialAuthException("Error while making request to URL : " + url, ie);
            }
        }
        if (MethodType.PUT.toString().equals(methodType)) {
            try {
                response = this.oauth.httpPut(url, params, headerParams, body, this.accessToken);
            }
            catch (Exception e) {
                throw new SocialAuthException("Error while making request to URL : " + url, e);
            }
        }
        return response;
    }

    @Override
    public void setPermission(Permission permission) {
        this.permission = permission;
    }

    @Override
    public void setScope(String scope) {
        this.scope = scope;
    }

    @Override
    public void setAccessGrant(AccessGrant accessGrant) {
        this.accessToken = accessGrant;
    }

    @Override
    public void setAccessTokenParameterName(String accessTokenParameterName) {
        this.LOG.warn((Object)"It is not implemented for Hybrid");
    }

    @Override
    public void logout() {
        this.accessToken = null;
        this.providerState = false;
    }
}

