/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.util;

import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.Response;

public class HttpUtil {
    private static final String ALLOWED_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_.!~*'()";

    public static Response doHttpRequest(String urlStr, String requestMethod, String body, Map<String, String> header) throws Exception {
        HttpURLConnection conn;
        try {
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setInstanceFollowRedirects(true);
            if (requestMethod != null) {
                conn.setRequestMethod(requestMethod);
            }
            if (header != null) {
                for (String key : header.keySet()) {
                    conn.setRequestProperty(key, header.get(key));
                }
            }
            OutputStreamWriter wr = null;
            if (body != null && requestMethod != null && !MethodType.GET.toString().equals(requestMethod) && !MethodType.DELETE.toString().equals(requestMethod)) {
                wr = new OutputStreamWriter(conn.getOutputStream());
                wr.write(body);
                wr.flush();
            }
            conn.connect();
        }
        catch (Exception e) {
            throw new SocialAuthException(e);
        }
        return new Response(conn);
    }

    public static String buildParams(Map<String, String> params) throws Exception {
        ArrayList<String> argList = new ArrayList<String>();
        for (String key : params.keySet()) {
            String val = params.get(key);
            if (val == null || val.length() <= 0) continue;
            String arg = key + "=" + HttpUtil.encodeURIComponent(val);
            argList.add(arg);
        }
        Collections.sort(argList);
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < argList.size(); ++i) {
            s.append((String)argList.get(i));
            if (i == argList.size() - 1) continue;
            s.append("&");
        }
        return s.toString();
    }

    public static String encodeURIComponent(String value) throws Exception {
        if (value == null) {
            return "";
        }
        try {
            return URLEncoder.encode(value, "utf-8").replace("+", "%20").replace("*", "%2A").replace("%7E", "~");
        }
        catch (UnsupportedEncodingException wow) {
            throw new SocialAuthException(wow.getMessage(), wow);
        }
    }

    private static String getHex(byte[] buf) {
        StringBuilder o = new StringBuilder(buf.length * 3);
        for (int i = 0; i < buf.length; ++i) {
            int n = buf[i] & 0xFF;
            o.append("%");
            if (n < 16) {
                o.append("0");
            }
            o.append(Long.toString(n, 16).toUpperCase());
        }
        return o.toString();
    }

    public static String decodeURIComponent(String encodedURI) {
        StringBuffer buffer = new StringBuffer();
        int sumb = 0;
        int more = -1;
        for (int i = 0; i < encodedURI.length(); ++i) {
            int bytePattern;
            char actualChar = encodedURI.charAt(i);
            switch (actualChar) {
                case '%': {
                    actualChar = encodedURI.charAt(++i);
                    int hb = (Character.isDigit(actualChar) ? actualChar - 48 : 10 + Character.toLowerCase(actualChar) - 97) & 0xF;
                    actualChar = encodedURI.charAt(++i);
                    int lb = (Character.isDigit(actualChar) ? actualChar - 48 : 10 + Character.toLowerCase(actualChar) - 97) & 0xF;
                    bytePattern = hb << 4 | lb;
                    break;
                }
                case '+': {
                    bytePattern = 32;
                    break;
                }
                default: {
                    bytePattern = actualChar;
                }
            }
            if ((bytePattern & 0xC0) == 128) {
                sumb = sumb << 6 | bytePattern & 0x3F;
                if (--more != 0) continue;
                buffer.append((char)sumb);
                continue;
            }
            if ((bytePattern & 0x80) == 0) {
                buffer.append((char)bytePattern);
                continue;
            }
            if ((bytePattern & 0xE0) == 192) {
                sumb = bytePattern & 0x1F;
                more = 1;
                continue;
            }
            if ((bytePattern & 0xF0) == 224) {
                sumb = bytePattern & 0xF;
                more = 2;
                continue;
            }
            if ((bytePattern & 0xF8) == 240) {
                sumb = bytePattern & 7;
                more = 3;
                continue;
            }
            if ((bytePattern & 0xFC) == 248) {
                sumb = bytePattern & 3;
                more = 4;
                continue;
            }
            sumb = bytePattern & 1;
            more = 5;
        }
        return buffer.toString();
    }
}

