/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.ProviderStateException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthConfigurationException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.util.HttpUtil;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class HotmailImpl
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = 4559561466129062485L;
    private static final String CONSENT_URL = "https://consent.live.com/Connect.aspx?wrap_client_id=%1$s&wrap_callback=%2$s";
    private static final String ACCESS_TOKEN_URL = "https://consent.live.com/AccessToken.aspx";
    private static final String PROFILE_URL = "http://apis.live.net/V4.1/cid-%1$s/Profiles/1-%2$s";
    private static final String CONTACTS_URL = "http://apis.live.net/V4.1/cid-%1$s/Contacts/AllContacts?$type=portable";
    private static final String UPDATE_STATUS_URL = "http://apis.live.net/V4.1/cid-%1$s/MyActivities";
    private static final String PROPERTY_DOMAIN = "consent.live.com";
    private final Log LOG = LogFactory.getLog(HotmailImpl.class);
    private String accessToken;
    private String uid;
    private String redirectUri;
    private Permission scope;
    private Properties properties;
    private boolean isVerify;
    private OAuthConfig config;
    private Profile userProfile;

    public HotmailImpl(Properties props) throws Exception {
        try {
            this.properties = props;
            this.config = OAuthConfig.load(this.properties, PROPERTY_DOMAIN);
        }
        catch (IllegalStateException e) {
            throw new SocialAuthConfigurationException(e);
        }
        if (this.config.get_consumerSecret().length() == 0) {
            throw new SocialAuthConfigurationException("consent.live.com.consumer_secret value is null");
        }
        if (this.config.get_consumerKey().length() == 0) {
            throw new SocialAuthConfigurationException("consent.live.com.consumer_key value is null");
        }
    }

    @Override
    public String getLoginRedirectURL(String redirectUri) throws Exception {
        this.LOG.info((Object)"Determining URL for redirection");
        this.setProviderState(true);
        this.redirectUri = redirectUri;
        String consentUrl = String.format(CONSENT_URL, this.config.get_consumerKey(), redirectUri);
        if (!Permission.AUHTHENTICATE_ONLY.equals(this.scope)) {
            consentUrl = consentUrl + "&wrap_scope=WL_Contacts.View,WL_Activities.Update";
        }
        this.LOG.info((Object)("Redirection to following URL should happen : " + consentUrl));
        return consentUrl;
    }

    @Override
    public Profile verifyResponse(HttpServletRequest request) throws Exception {
        Response serviceResponse;
        this.LOG.info((Object)"Retrieving Access Token in verify response function");
        if (request.getParameter("wrap_error_reason") != null && "user_denied".equals(request.getParameter("wrap_error_reason"))) {
            throw new UserDeniedPermissionException();
        }
        if (!this.isProviderState()) {
            throw new ProviderStateException();
        }
        String code = request.getParameter("wrap_verification_code");
        if (code == null || code.length() == 0) {
            throw new SocialAuthException("Verification code is null");
        }
        StringBuilder strb = new StringBuilder();
        strb.append("wrap_client_id=").append(this.config.get_consumerKey());
        strb.append("&wrap_client_secret=").append(this.config.get_consumerSecret());
        strb.append("&wrap_callback=").append(this.redirectUri);
        strb.append("&wrap_verification_code=").append(code);
        strb.append("&idtype=CID");
        this.LOG.debug((Object)("Parameters for access token : " + strb.toString()));
        try {
            serviceResponse = HttpUtil.doHttpRequest(ACCESS_TOKEN_URL, MethodType.POST.toString(), strb.toString(), null);
        }
        catch (Exception e) {
            throw new SocialAuthException(e);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthConfigurationException("Problem in getting Access Token. Application key or Secret key may be wrong.The server running the application should be same that was registered to get the keys.");
        }
        String result = null;
        if (serviceResponse.getStatus() == 200) {
            try {
                result = serviceResponse.getResponseBodyAsString("UTF-8");
            }
            catch (Exception exc) {
                throw new SocialAuthException("Failed to parse response", exc);
            }
        }
        if (result == null || result.length() == 0) {
            throw new SocialAuthConfigurationException("Problem in getting Access Token. Application key or Secret key may be wrong.The server running the application should be same that was registered to get the keys.");
        }
        try {
            String[] pairs;
            Integer expires = null;
            for (String pair : pairs = result.split("&")) {
                String[] kv = pair.split("=");
                if (kv.length != 2) {
                    throw new SocialAuthException("Unexpected auth response from https://consent.live.com/AccessToken.aspx");
                }
                if (kv[0].equals("wrap_access_token")) {
                    this.accessToken = kv[1];
                }
                if (kv[0].equals("wrap_access_token_expires_in")) {
                    expires = Integer.valueOf(kv[1]);
                }
                if (kv[0].equals("uid")) {
                    this.uid = kv[1];
                }
                this.LOG.debug((Object)("Access Token : " + this.accessToken));
                this.LOG.debug((Object)("Expires : " + expires));
            }
            if (this.accessToken != null && expires != null) {
                this.isVerify = true;
                this.LOG.debug((Object)"Obtaining user profile");
                Profile profile = this.userProfile = this.getProfile();
                return profile;
            }
            throw new SocialAuthException("Access token and expires not found from https://consent.live.com/AccessToken.aspx");
        }
        finally {
            serviceResponse.close();
        }
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        String u = String.format(CONTACTS_URL, this.uid);
        this.LOG.info((Object)("Fetching contacts from " + u));
        return this.getContacts(u, 0);
    }

    private List<Contact> getContacts(String url, int page) throws Exception {
        int total;
        String result;
        Response serviceResponse;
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put("Authorization", "WRAP access_token=" + this.accessToken);
        headerParam.put("Content-Type", "application/json");
        headerParam.put("Accept", "application/json");
        try {
            serviceResponse = HttpUtil.doHttpRequest(url, "GET", null, headerParam);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting contacts from " + url, e);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Error while getting contacts from " + url + "Status : " + serviceResponse.getStatus());
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to get response from " + url);
        }
        this.LOG.debug((Object)("User Contacts list in JSON " + result));
        JSONObject resp = new JSONObject(result);
        ArrayList<Contact> plist = new ArrayList<Contact>();
        if (resp.has("entries")) {
            JSONArray addArr = resp.getJSONArray("entries");
            this.LOG.debug((Object)("Contacts Found : " + addArr.length()));
            for (int i = 0; i < addArr.length(); ++i) {
                JSONArray emailArr;
                int emailCount;
                JSONObject obj = addArr.getJSONObject(i);
                Contact p = new Contact();
                if (obj.has("emails") && (emailCount = (emailArr = obj.getJSONArray("emails")).length()) > 0) {
                    JSONObject eobj = emailArr.getJSONObject(0);
                    if (eobj.has("value")) {
                        p.setEmail(eobj.getString("value"));
                    }
                    if (emailCount > 1) {
                        String[] sarr = new String[emailCount - 1];
                        for (int k = 0; k < emailCount - 1; ++k) {
                            eobj = emailArr.getJSONObject(k + 1);
                            if (!eobj.has("value")) continue;
                            sarr[k] = eobj.getString("value");
                        }
                        p.setOtherEmails(sarr);
                    }
                }
                if (obj.has("name")) {
                    JSONObject nameObj = obj.getJSONObject("name");
                    if (nameObj.has("familyName")) {
                        p.setLastName(nameObj.getString("familyName"));
                    }
                    if (nameObj.has("formatted")) {
                        p.setDisplayName(nameObj.getString("formatted"));
                    }
                    if (nameObj.has("givenName")) {
                        p.setFirstName(nameObj.getString("givenName"));
                    }
                }
                plist.add(p);
            }
        }
        if (resp.has("totalResults") && (total = resp.getInt("totalResults")) == 100) {
            int p = page + 1;
            String u = String.format(CONTACTS_URL, this.uid);
            u = u + "&$skip=" + p * 100;
            plist.addAll(this.getContacts(u, p));
        }
        serviceResponse.close();
        return plist;
    }

    @Override
    public void updateStatus(String msg) throws Exception {
        this.LOG.info((Object)("Updating status : " + msg));
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        if (msg == null || msg.trim().length() == 0) {
            throw new ServerDataException("Status cannot be blank");
        }
        String u = String.format(UPDATE_STATUS_URL, this.uid);
        String body = "{\"__type\" : \"AddStatusActivity:http://schemas.microsoft.com/ado/2007/08/dataservices\",\"ActivityVerb\" : \"http://activitystrea.ms/schema/1.0/post\",\"ApplicationLink\" : \"http://rex.mslivelabs.com\",\"ActivityObjects\" : [{\"ActivityObjectType\" : \"http://activitystrea.ms/schema/1.0/status\",\"Content\" : \"" + msg + "\",\"AlternateLink\" : \"http://www.contoso.com/wp-content/uploads/2009/06/comments-icon.jpg\"}}]}";
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put("Authorization", "WRAP access_token=" + this.accessToken);
        headerParam.put("Content-Type", "application/json");
        headerParam.put("Accept", "application/json");
        headerParam.put("Content-Length", new Integer(body.length()).toString());
        Response serviceResponse = HttpUtil.doHttpRequest(u, MethodType.POST.toString(), body, headerParam);
        int code = serviceResponse.getStatus();
        this.LOG.debug((Object)("Status updated and return status code is :" + code));
        serviceResponse.close();
    }

    @Override
    public void logout() {
        this.accessToken = null;
    }

    private Profile getProfile() throws Exception {
        String result;
        Response serviceResponse;
        Profile p = new Profile();
        String u = String.format(PROFILE_URL, this.uid, this.uid);
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put("Authorization", "WRAP access_token=" + this.accessToken);
        headerParam.put("Content-Type", "application/json");
        headerParam.put("Accept", "application/json");
        try {
            serviceResponse = HttpUtil.doHttpRequest(u, "GET", null, headerParam);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + u, e);
        }
        try {
            result = serviceResponse.getResponseBodyAsString("UTF-8");
            this.LOG.debug((Object)("User Profile :" + result));
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to read response from  " + u);
        }
        try {
            JSONObject resp = new JSONObject(result);
            if (resp.has("Id")) {
                p.setValidatedId(resp.getString("Id"));
            }
            if (resp.has("FirstName")) {
                p.setFirstName(resp.getString("FirstName"));
            }
            if (resp.has("LastName")) {
                p.setLastName(resp.getString("LastName"));
            }
            if (resp.has("Location")) {
                p.setLocation(resp.getString("Location"));
            }
            if (resp.has("Gender")) {
                String g = resp.getString("Gender");
                if ("1".equals(g)) {
                    p.setGender("Female");
                } else if ("2".equals(g)) {
                    p.setGender("Male");
                }
            }
            if (resp.has("ThumbnailImageLink")) {
                p.setProfileImageURL(resp.getString("ThumbnailImageLink"));
            }
            if (resp.has("Emails")) {
                JSONArray earr = resp.getJSONArray("Emails");
                for (int i = 0; i < earr.length(); ++i) {
                    JSONObject eobj = earr.getJSONObject(i);
                    if (!eobj.has("Type") || !"1".equals(eobj.getString("Type"))) continue;
                    p.setEmail(eobj.getString("Address"));
                    break;
                }
                if (p.getEmail() == null || p.getEmail().length() <= 0) {
                    JSONObject eobj = earr.getJSONObject(0);
                    p.setEmail(eobj.getString("Address"));
                }
            }
            serviceResponse.close();
            return p;
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to parse the user profile json : " + result);
        }
    }

    @Override
    public void setPermission(Permission p) {
        this.scope = p;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        Response serviceResponse;
        HashMap<String, String> headerParam = new HashMap<String, String>();
        headerParam.put("Content-Type", "application/json");
        headerParam.put("Accept", "application/json");
        if (headerParams != null) {
            headerParam.putAll(headerParams);
        }
        headerParam.put("Authorization", "WRAP access_token=" + this.accessToken);
        String urlStr = String.format(url, this.uid);
        this.LOG.debug((Object)("Calling URL : " + urlStr));
        this.LOG.debug((Object)("Header Params : " + ((Object)headerParam).toString()));
        try {
            serviceResponse = HttpUtil.doHttpRequest(urlStr, methodType, body, headerParam);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while making request to URL : " + urlStr, e);
        }
        if (serviceResponse.getStatus() != 200) {
            this.LOG.debug((Object)("Return statuc for URL " + urlStr + " is " + serviceResponse.getStatus()));
            throw new SocialAuthException("Error while making request to URL :" + urlStr + "Status : " + serviceResponse.getStatus());
        }
        return serviceResponse;
    }

    @Override
    public Profile getUserProfile() {
        return this.userProfile;
    }
}

