/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.ProviderStateException;
import org.brickred.socialauth.exception.SocialAuthConfigurationException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.util.HttpUtil;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class FourSquareImpl
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = 3364430495809289118L;
    private static final String PROFILE_URL = "https://api.foursquare.com/v2/users/self?oauth_token=";
    private static final String CONTACTS_URL = "https://api.foursquare.com/v2/users/self/friends?oauth_token=";
    private static final String REQUEST_TOKEN_URL = "https://foursquare.com/oauth2/authenticate?client_id=%1$s&response_type=code&redirect_uri=%2$s";
    private static final String ACCESS_TOKEN_URL = "https://foursquare.com/oauth2/access_token";
    private static final String VIEW_PROFILE_URL = "http://foursquare.com/user/";
    private static final String PROPERTY_DOMAIN = "foursquare.com";
    private final Log LOG = LogFactory.getLog(FourSquareImpl.class);
    private Permission scope;
    private Properties properties;
    private boolean isVerify;
    private String redirectUri;
    private String accessToken;
    private OAuthConfig config;
    private Profile userProfile;

    public FourSquareImpl(Properties props) throws Exception {
        try {
            this.properties = props;
            this.config = OAuthConfig.load(this.properties, PROPERTY_DOMAIN);
        }
        catch (IllegalStateException e) {
            throw new SocialAuthConfigurationException(e);
        }
        if (this.config.get_consumerSecret().length() == 0) {
            throw new SocialAuthConfigurationException("foursquare.com.consumer_secret value is null");
        }
        if (this.config.get_consumerKey().length() == 0) {
            throw new SocialAuthConfigurationException("foursquare.com.consumer_key value is null");
        }
    }

    @Override
    public String getLoginRedirectURL(String redirectUri) throws Exception {
        this.LOG.info((Object)"Determining URL for redirection");
        this.setProviderState(true);
        this.redirectUri = redirectUri;
        String reqTokenUrl = String.format(REQUEST_TOKEN_URL, this.config.get_consumerKey(), redirectUri);
        this.LOG.info((Object)("Redirection to following URL should happen : " + reqTokenUrl));
        return reqTokenUrl;
    }

    @Override
    public Profile verifyResponse(HttpServletRequest request) throws Exception {
        this.LOG.info((Object)"Verifying the authentication response from provider");
        if (request.getParameter("error") != null && "access_denied".equals(request.getParameter("error"))) {
            throw new UserDeniedPermissionException();
        }
        if (!this.isProviderState()) {
            throw new ProviderStateException();
        }
        String code = request.getParameter("code");
        if (code == null || code.length() == 0) {
            throw new SocialAuthException("Verification code is null");
        }
        StringBuilder strb = new StringBuilder();
        strb.append("client_id=").append(this.config.get_consumerKey()).append("&");
        strb.append("client_secret=").append(this.config.get_consumerSecret()).append("&");
        strb.append("grant_type=authorization_code&");
        strb.append("redirect_uri=").append(this.redirectUri).append("&");
        strb.append("code=").append(code);
        Response serviceResponse = HttpUtil.doHttpRequest(ACCESS_TOKEN_URL, MethodType.POST.toString(), strb.toString(), null);
        String result = null;
        if (serviceResponse.getStatus() == 200) {
            try {
                result = serviceResponse.getResponseBodyAsString("UTF-8");
            }
            catch (Exception exc) {
                throw new SocialAuthException("Failed to read response from  https://foursquare.com/oauth2/access_token");
            }
        }
        if (result == null || result.length() == 0) {
            throw new SocialAuthConfigurationException("Problem in getting Access Token. Application key or Secret key may be wrong.The server running the application should be same that was registered to get the keys.");
        }
        JSONObject jobj = new JSONObject(result);
        if (jobj.has("access_token")) {
            this.accessToken = jobj.getString("access_token");
        }
        if (this.accessToken != null) {
            this.isVerify = true;
            this.LOG.debug((Object)"Obtaining user profile");
            this.userProfile = this.getProfile();
            return this.userProfile;
        }
        throw new SocialAuthException("Access token and expires not found from https://foursquare.com/oauth2/access_token");
    }

    private Profile getProfile() throws Exception {
        JSONObject cobj;
        String res;
        Response serviceResponse;
        this.LOG.debug((Object)"Obtaining user profile");
        Profile profile = new Profile();
        String u = PROFILE_URL + this.accessToken;
        try {
            serviceResponse = HttpUtil.doHttpRequest(u, MethodType.GET.toString(), null, null);
        }
        catch (Exception e) {
            throw new SocialAuthException("Failed to retrieve the user profile from  " + u, e);
        }
        try {
            res = serviceResponse.getResponseBodyAsString("UTF-8");
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read response from  " + u);
        }
        JSONObject jobj = new JSONObject(res);
        if (!jobj.has("response")) {
            throw new SocialAuthException("Failed to parse the user profile json : " + res);
        }
        JSONObject rObj = jobj.getJSONObject("response");
        if (!rObj.has("user")) {
            throw new SocialAuthException("Failed to parse the user profile json : " + res);
        }
        JSONObject uObj = rObj.getJSONObject("user");
        if (uObj.has("id")) {
            profile.setValidatedId(uObj.getString("id"));
        }
        if (uObj.has("firstName")) {
            profile.setFirstName(uObj.getString("firstName"));
        }
        if (uObj.has("lastName")) {
            profile.setLastName(uObj.getString("lastName"));
        }
        if (uObj.has("photo")) {
            profile.setProfileImageURL(uObj.getString("photo"));
        }
        if (uObj.has("gender")) {
            profile.setGender(uObj.getString("gender"));
        }
        if (uObj.has("homeCity")) {
            profile.setLocation(uObj.getString("homeCity"));
        }
        if (uObj.has("contact") && (cobj = uObj.getJSONObject("contact")).has("email")) {
            profile.setEmail(cobj.getString("email"));
        }
        return profile;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Contact> getContactList() throws Exception {
        String respStr;
        Response serviceResponse;
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        String url = CONTACTS_URL + this.accessToken;
        this.LOG.info((Object)("Fetching contacts from " + url));
        try {
            serviceResponse = HttpUtil.doHttpRequest(url, MethodType.GET.toString(), null, null);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting contacts from " + url);
        }
        if (serviceResponse.getStatus() != 200) {
            throw new SocialAuthException("Error while getting contacts from " + url + "Status : " + serviceResponse.getStatus());
        }
        try {
            respStr = serviceResponse.getResponseBodyAsString("UTF-8");
        }
        catch (Exception exc) {
            throw new SocialAuthException("Failed to read response from  " + url);
        }
        this.LOG.debug((Object)("User Contacts list in JSON " + respStr));
        JSONObject resp = new JSONObject(respStr);
        ArrayList<Contact> plist = new ArrayList<Contact>();
        JSONArray items = new JSONArray();
        if (!resp.has("response")) throw new SocialAuthException("Failed to parse the user profile json : " + respStr);
        JSONObject robj = resp.getJSONObject("response");
        if (!robj.has("friends")) throw new SocialAuthException("Failed to parse the user profile json : " + respStr);
        JSONObject fobj = robj.getJSONObject("friends");
        if (fobj.has("items")) {
            items = fobj.getJSONArray("items");
        }
        this.LOG.debug((Object)("Contacts Found : " + items.length()));
        for (int i = 0; i < items.length(); ++i) {
            JSONObject obj = items.getJSONObject(i);
            Contact c = new Contact();
            if (obj.has("firstName")) {
                c.setFirstName(obj.getString("firstName"));
            }
            if (obj.has("lastName")) {
                c.setLastName(obj.getString("lastName"));
            }
            if (obj.has("id")) {
                c.setProfileUrl(VIEW_PROFILE_URL + obj.getString("id"));
            }
            plist.add(c);
        }
        return plist;
    }

    @Override
    public void updateStatus(String msg) throws Exception {
        this.LOG.warn((Object)"WARNING: Not implemented for FourSquare");
        throw new SocialAuthException("Update Status is not implemented for FourSquare");
    }

    @Override
    public void logout() {
        this.accessToken = null;
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        Response response = null;
        if (!this.isProviderState()) {
            throw new ProviderStateException();
        }
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        char separator = url.indexOf(63) == -1 ? (char)'?' : '&';
        String urlStr = url + separator + "oauth_token=" + this.accessToken;
        this.LOG.debug((Object)("Calling URL : " + urlStr));
        if (MethodType.GET.toString().equals(methodType)) {
            try {
                response = HttpUtil.doHttpRequest(urlStr, MethodType.GET.toString(), null, headerParams);
            }
            catch (Exception e) {
                throw new SocialAuthException("Error while making request to URL : " + urlStr, e);
            }
        }
        if (MethodType.PUT.toString().equals(methodType) || MethodType.POST.toString().equals(methodType)) {
            try {
                response = HttpUtil.doHttpRequest(urlStr, methodType, body, headerParams);
            }
            catch (Exception e) {
                throw new SocialAuthException("Error while making request to URL : " + urlStr, e);
            }
        }
        return response;
    }

    @Override
    public Profile getUserProfile() {
        return this.userProfile;
    }
}

