/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.IOException;
import java.io.Serializable;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AbstractProvider;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.exception.ProviderStateException;
import org.brickred.socialauth.exception.ServerDataException;
import org.brickred.socialauth.exception.SocialAuthConfigurationException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.exception.UserDeniedPermissionException;
import org.brickred.socialauth.util.HttpUtil;
import org.brickred.socialauth.util.MethodType;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;
import org.json.JSONArray;
import org.json.JSONObject;

public class FacebookImpl
extends AbstractProvider
implements AuthProvider,
Serializable {
    private static final long serialVersionUID = 8644510564735754296L;
    private static final String PROPERTY_DOMAIN = "graph.facebook.com";
    private static final String AUTHORIZATION_URL = "https://graph.facebook.com/oauth/authorize?client_id=%1$s&display=page&redirect_uri=%2$s";
    private static final String ACCESS_TOKEN_URL = "https://graph.facebook.com/oauth/access_token?client_id=%1$s&redirect_uri=%2$s&client_secret=%3$s&code=%4$s";
    private static final String PROFILE_URL = "https://graph.facebook.com/me?access_token=%1$s";
    private static final String CONTACTS_URL = "https://graph.facebook.com/me/friends?access_token=%1$s";
    private static final String UPDATE_STATUS_URL = "https://graph.facebook.com/me/feed";
    private static final String PROFILE_IMAGE_URL = "http://graph.facebook.com/%1$s/picture";
    private static final String PUBLIC_PROFILE_URL = "http://www.facebook.com/profile.php?id=";
    private final Log LOG = LogFactory.getLog(FacebookImpl.class);
    private String accessToken;
    private String redirectUri;
    private Permission scope;
    private Properties properties;
    private boolean isVerify;
    private OAuthConfig config;
    private Profile userProfile;
    private static final String[] AllPerms = new String[]{"publish_stream", "email", "user_birthday", "user_location"};
    private static final String[] AuthPerms = new String[]{"email", "user_birthday", "user_location"};

    public FacebookImpl(Properties props) throws Exception {
        try {
            this.properties = props;
            this.config = OAuthConfig.load(this.properties, PROPERTY_DOMAIN);
        }
        catch (IllegalStateException e) {
            throw new SocialAuthConfigurationException(e);
        }
        if (this.config.get_consumerSecret().length() <= 0) {
            throw new SocialAuthConfigurationException("graph.facebook.com.consumer_secret value is null");
        }
        if (this.config.get_consumerKey().length() <= 0) {
            throw new SocialAuthConfigurationException("graph.facebook.com.consumer_key value is null");
        }
    }

    @Override
    public String getLoginRedirectURL(String redirectUri) {
        this.LOG.info((Object)"Determining URL for redirection");
        this.setProviderState(true);
        this.redirectUri = redirectUri;
        String url = String.format(AUTHORIZATION_URL, this.config.get_consumerKey(), redirectUri);
        StringBuffer result = new StringBuffer();
        boolean isFirstSet = false;
        if (Permission.AUHTHENTICATE_ONLY.equals(this.scope)) {
            result.append(AuthPerms[0]);
            for (int i = 1; i < AuthPerms.length; ++i) {
                if (!isFirstSet) continue;
                result.append(",").append(AuthPerms[i]);
            }
        } else {
            result.append(AllPerms[0]);
            for (int i = 1; i < AllPerms.length; ++i) {
                result.append(",").append(AllPerms[i]);
            }
        }
        url = url + "&scope=" + result.toString();
        this.LOG.info((Object)("Redirection to following URL should happen : " + url));
        return url;
    }

    @Override
    public Profile verifyResponse(HttpServletRequest httpReq) throws Exception {
        String[] pairs;
        String result;
        Response response;
        String acode;
        this.LOG.info((Object)"Retrieving Access Token in verify response function");
        if (httpReq.getParameter("error_reason") != null && "user_denied".equals(httpReq.getParameter("error_reason"))) {
            throw new UserDeniedPermissionException();
        }
        if (!this.isProviderState()) {
            throw new ProviderStateException();
        }
        String code = httpReq.getParameter("code");
        if (code == null || code.length() == 0) {
            throw new SocialAuthException("Verification code is null");
        }
        this.LOG.debug((Object)("Verification Code : " + code));
        try {
            acode = URLEncoder.encode(code, "UTF-8");
        }
        catch (Exception e) {
            acode = code;
        }
        String authURL = String.format(ACCESS_TOKEN_URL, this.config.get_consumerKey(), this.redirectUri, this.config.get_consumerSecret(), acode);
        try {
            response = HttpUtil.doHttpRequest(authURL, MethodType.GET.toString(), null, null);
        }
        catch (Exception e) {
            throw new SocialAuthException("Error in url : " + authURL, e);
        }
        try {
            result = response.getResponseBodyAsString("UTF-8");
        }
        catch (IOException io) {
            throw new SocialAuthException(io);
        }
        Integer expires = null;
        for (String pair : pairs = result.split("&")) {
            String[] kv = pair.split("=");
            if (kv.length != 2) {
                throw new SocialAuthException("Unexpected auth response from " + authURL);
            }
            if (kv[0].equals("access_token")) {
                this.accessToken = kv[1];
            }
            if (kv[0].equals("expires")) {
                expires = Integer.valueOf(kv[1]);
            }
            this.LOG.debug((Object)("Access Token : " + this.accessToken));
            this.LOG.debug((Object)("Expires : " + expires));
        }
        if (this.accessToken != null && expires != null) {
            this.isVerify = true;
            this.LOG.debug((Object)"Obtaining user profile");
            return this.authFacebookLogin(this.accessToken, expires);
        }
        throw new SocialAuthException("Access token and expires not found from " + authURL);
    }

    private Profile authFacebookLogin(String accessToken, int expires) throws Exception {
        String presp;
        String aToken;
        try {
            aToken = URLEncoder.encode(accessToken, "UTF-8");
        }
        catch (Exception e) {
            aToken = accessToken;
        }
        String profileurl = String.format(PROFILE_URL, aToken);
        try {
            Response response = HttpUtil.doHttpRequest(profileurl, MethodType.GET.toString(), null, null);
            presp = response.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting profile from " + profileurl, e);
        }
        try {
            this.LOG.debug((Object)("User Profile : " + presp));
            JSONObject resp = new JSONObject(presp);
            Profile p = new Profile();
            p.setValidatedId(resp.getString("id"));
            p.setFirstName(resp.getString("first_name"));
            p.setLastName(resp.getString("last_name"));
            p.setEmail(resp.getString("email"));
            if (resp.has("location")) {
                p.setLocation(resp.getJSONObject("location").getString("name"));
            }
            if (resp.has("birthday")) {
                p.setDob(resp.getString("birthday"));
            }
            if (resp.has("gender")) {
                p.setGender(resp.getString("gender"));
            }
            p.setProfileImageURL(String.format(PROFILE_IMAGE_URL, resp.getString("id")));
            String locale = resp.getString("locale");
            if (locale != null) {
                String[] a = locale.split("_");
                p.setLanguage(a[0]);
                p.setCountry(a[1]);
            }
            this.userProfile = p;
            return p;
        }
        catch (Exception ex) {
            throw new ServerDataException("Failed to parse the user profile json : " + presp, ex);
        }
    }

    @Override
    public void updateStatus(String msg) throws Exception {
        this.LOG.info((Object)("Updating status : " + msg));
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token and then update status");
        }
        if (msg == null || msg.trim().length() == 0) {
            throw new ServerDataException("Status cannot be blank");
        }
        StringBuilder strb = new StringBuilder();
        strb.append("access_token=").append(this.accessToken).append("&");
        strb.append("message=").append(msg);
        try {
            Response serviceResponse = HttpUtil.doHttpRequest(UPDATE_STATUS_URL, MethodType.POST.toString(), strb.toString(), null);
            if (serviceResponse.getStatus() != 200) {
                throw new SocialAuthException("Status not updated. Return Status code :" + serviceResponse.getStatus());
            }
        }
        catch (Exception e) {
            throw new SocialAuthException(e);
        }
    }

    @Override
    public List<Contact> getContactList() throws Exception {
        String respStr;
        if (!this.isProviderState()) {
            throw new ProviderStateException();
        }
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        ArrayList<Contact> plist = new ArrayList<Contact>();
        String contactURL = String.format(CONTACTS_URL, this.accessToken);
        this.LOG.info((Object)("Fetching contacts from " + contactURL));
        try {
            Response response = HttpUtil.doHttpRequest(contactURL, MethodType.GET.toString(), null, null);
            respStr = response.getResponseBodyAsString("UTF-8");
        }
        catch (Exception e) {
            throw new SocialAuthException("Error while getting contacts from " + contactURL);
        }
        try {
            this.LOG.debug((Object)("User Contacts list in json : " + respStr));
            JSONObject resp = new JSONObject(respStr);
            JSONArray data = resp.getJSONArray("data");
            this.LOG.debug((Object)("Found contacts : " + data.length()));
            for (int i = 0; i < data.length(); ++i) {
                JSONObject obj = data.getJSONObject(i);
                Contact p = new Contact();
                p.setFirstName(obj.getString("name"));
                p.setProfileUrl(PUBLIC_PROFILE_URL + obj.getString("id"));
                plist.add(p);
            }
        }
        catch (Exception e) {
            throw new ServerDataException("Failed to parse the user profile json : " + respStr, e);
        }
        return plist;
    }

    @Override
    public void logout() {
        this.accessToken = null;
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
        this.scope = p;
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        Response response = null;
        if (!this.isProviderState()) {
            throw new ProviderStateException();
        }
        if (!this.isVerify) {
            throw new SocialAuthException("Please call verifyResponse function first to get Access Token");
        }
        if (MethodType.GET.toString().equals(methodType)) {
            String urlStr = url;
            try {
                char separator = url.indexOf(63) == -1 ? (char)'?' : '&';
                urlStr = urlStr + separator + "access_token=" + this.accessToken;
                this.LOG.debug((Object)("Calling URL : " + urlStr));
                response = HttpUtil.doHttpRequest(urlStr, MethodType.GET.toString(), null, headerParams);
            }
            catch (Exception e) {
                throw new SocialAuthException("Error while making request to URL : " + urlStr, e);
            }
        }
        if (MethodType.PUT.toString().equals(methodType) || MethodType.POST.toString().equals(methodType)) {
            StringBuilder strb = new StringBuilder();
            strb.append("access_token=").append(this.accessToken);
            if (body != null) {
                strb.append("&").append(body);
            }
            try {
                this.LOG.debug((Object)("Calling URL : " + url));
                this.LOG.debug((Object)("Request Body : " + strb.toString()));
                response = HttpUtil.doHttpRequest(url, methodType, strb.toString(), headerParams);
            }
            catch (Exception e) {
                throw new SocialAuthException("Error while making request to URL : " + url, e);
            }
        }
        return response;
    }

    @Override
    public Profile getUserProfile() {
        return this.userProfile;
    }
}

