/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.provider;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Permission;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.util.OAuthConfig;
import org.brickred.socialauth.util.Response;

public class AolImpl
implements AuthProvider {
    private static Pattern nameValSplitter = Pattern.compile("[=&]", 2);
    private String dev_id;
    private String token;
    private String redirectUri;
    private OAuthConfig config;
    private final Log LOG = LogFactory.getLog(AolImpl.class);

    public AolImpl(Properties props) {
        this.config = OAuthConfig.load(props, "api.screenname.aol.com");
        this.dev_id = this.config.get_consumerKey();
    }

    @Override
    public String getLoginRedirectURL(String redirectUri) {
        this.redirectUri = redirectUri;
        return "https://api.screenname.aol.com/auth/login?f=qs&succUrl=" + redirectUri + "&devId=" + this.dev_id;
    }

    @Override
    public Profile verifyResponse(HttpServletRequest request) {
        try {
            this.token = request.getParameter("token_a");
            String encodedToken = URLEncoder.encode(this.token, "UTF-8");
            String getInfoUrl = "https://api.screenname.aol.com/auth/getInfo?f=qs&devId=" + this.dev_id + "&referer=" + this.redirectUri + "&a=" + encodedToken;
            Map responseParamMap = this.getHttpResponseParameters(getInfoUrl);
            String statusCode = (String)responseParamMap.get("statusCode");
            if (statusCode != null && statusCode.equals("200")) {
                Profile p = new Profile();
                p.setFullName((String)responseParamMap.get("userData_displayName"));
                String[] str = p.getFullName().split(" ");
                p.setFirstName(str[0]);
                p.setLastName(str.length > 1 ? str[1] : " ");
                p.setEmail((String)responseParamMap.get("userData_loginId"));
                p.setValidatedId((String)responseParamMap.get("userData_loginId"));
                return p;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private Map getHttpResponseParameters(String Url) throws MalformedURLException, IOException {
        String inputLine;
        URL getInfo = new URL(Url);
        StringBuffer responseBuf = new StringBuffer();
        BufferedReader in = new BufferedReader(new InputStreamReader(getInfo.openStream()));
        while ((inputLine = in.readLine()) != null) {
            responseBuf.append(inputLine);
        }
        String getInfoResponse = responseBuf.toString();
        String[] nameValuePairs = nameValSplitter.split(getInfoResponse);
        HashMap<String, String> responseParamMap = new HashMap<String, String>();
        for (int i = 0; i < nameValuePairs.length; i += 2) {
            responseParamMap.put(nameValuePairs[i], URLDecoder.decode(nameValuePairs[i + 1]));
        }
        return responseParamMap;
    }

    @Override
    public List<Contact> getContactList() {
        ArrayList<Contact> plist = new ArrayList<Contact>();
        try {
            String inputLine;
            String encodedToken = URLEncoder.encode(this.token, "UTF-8");
            String u = "http://api.oscar.aol.com/presence/get?f=json&bl=1&k=" + this.dev_id + "&a=" + encodedToken;
            URL connURL = new URL(u);
            HttpURLConnection urlConn = (HttpURLConnection)connURL.openConnection();
            urlConn.setRequestProperty("referer", "http://localhost:8080/AuthApp/");
            StringBuffer responseBuf = new StringBuffer();
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConn.getInputStream(), "UTF-8"));
            while ((inputLine = in.readLine()) != null) {
                responseBuf.append(inputLine);
            }
            this.LOG.debug((Object)responseBuf.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return plist;
    }

    @Override
    public void updateStatus(String msg) {
        this.LOG.warn((Object)"Update status not implemented");
    }

    @Override
    public void logout() {
        this.token = null;
    }

    @Override
    public void setPermission(Permission p) {
        this.LOG.debug((Object)("Permission requested : " + p.toString()));
    }

    @Override
    public Response api(String url, String methodType, Map<String, String> params, Map<String, String> headerParams, String body) throws Exception {
        return null;
    }

    @Override
    public Profile getUserProfile() {
        return null;
    }
}

