/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.exception.SocialAuthConfigurationException;
import org.brickred.socialauth.exception.SocialAuthException;
import org.brickred.socialauth.provider.FacebookImpl;
import org.brickred.socialauth.provider.FourSquareImpl;
import org.brickred.socialauth.provider.GoogleImpl;
import org.brickred.socialauth.provider.HotmailImpl;
import org.brickred.socialauth.provider.LinkedInImpl;
import org.brickred.socialauth.provider.MySpaceImpl;
import org.brickred.socialauth.provider.OpenIdImpl;
import org.brickred.socialauth.provider.TwitterImpl;
import org.brickred.socialauth.provider.YahooImpl;

public class AuthProviderFactory {
    private static String propFileName = "oauth_consumer.properties";
    private static Map<String, Class> providerMap;
    private static final Log LOG;

    public static AuthProvider getInstance(String id) throws Exception {
        AuthProvider provider = AuthProviderFactory.getProvider(id, propFileName, null);
        return provider;
    }

    public static AuthProvider getInstance(String id, String propertiesFileName) throws Exception {
        AuthProvider provider = AuthProviderFactory.getProvider(id, propertiesFileName, null);
        return provider;
    }

    public static AuthProvider getInstance(String id, ClassLoader classLoader) throws Exception {
        AuthProvider provider = AuthProviderFactory.getProvider(id, propFileName, classLoader);
        return provider;
    }

    public static AuthProvider getInstance(String id, String propertiesFileName, ClassLoader classLoader) throws Exception {
        AuthProvider provider = AuthProviderFactory.getProvider(id, propertiesFileName, classLoader);
        return provider;
    }

    public static AuthProvider getInstance(String id, Properties properties) throws Exception {
        return AuthProviderFactory.loadProvider(id, properties);
    }

    private static AuthProvider getProvider(String id, String fileName, ClassLoader classLoader) throws Exception {
        Properties props = new Properties();
        ClassLoader loader = null;
        loader = classLoader != null ? classLoader : AuthProviderFactory.class.getClassLoader();
        try {
            InputStream in = loader.getResourceAsStream(fileName);
            props.load(in);
            for (String string : props.keySet()) {
                if (!string.startsWith("socialauth.")) continue;
                String val = string.substring("socialauth.".length());
                AuthProviderFactory.registerProvider(val, Class.forName(props.get(string).toString()));
            }
        }
        catch (NullPointerException ne) {
            throw new FileNotFoundException(fileName + " file is not found in your class path");
        }
        catch (IOException ie) {
            throw new IOException("Could not load configuration from " + fileName);
        }
        AuthProvider provider = AuthProviderFactory.loadProvider(id, props);
        return provider;
    }

    private static AuthProvider loadProvider(String id, Properties props) throws Exception {
        AuthProvider provider;
        Class obj = providerMap.get(id);
        props.setProperty("id", id);
        if (obj == null) {
            try {
                new URL(id);
                obj = providerMap.get("openid");
            }
            catch (MalformedURLException me) {
                throw new SocialAuthException(id + " is not a provider or valid OpenId URL");
            }
        }
        try {
            Constructor cons = obj.getConstructor(Properties.class);
            provider = (AuthProvider)cons.newInstance(props);
        }
        catch (NoSuchMethodException me) {
            LOG.warn((Object)(obj.getName() + " does not implement a constructor " + obj.getName() + "(Poperties props)"));
            provider = (AuthProvider)obj.newInstance();
        }
        catch (Exception e) {
            throw new SocialAuthConfigurationException(e);
        }
        return provider;
    }

    public static void registerProvider(String pname, Class clazz) {
        providerMap.put(pname, clazz);
    }

    static {
        LOG = LogFactory.getLog(AuthProviderFactory.class);
        providerMap = new HashMap<String, Class>();
        providerMap.put("facebook", FacebookImpl.class);
        providerMap.put("foursquare", FourSquareImpl.class);
        providerMap.put("google", GoogleImpl.class);
        providerMap.put("hotmail", HotmailImpl.class);
        providerMap.put("linkedin", LinkedInImpl.class);
        providerMap.put("myspace", MySpaceImpl.class);
        providerMap.put("openid", OpenIdImpl.class);
        providerMap.put("twitter", TwitterImpl.class);
        providerMap.put("yahoo", YahooImpl.class);
    }
}

