/*
 * Decompiled with CFR 0.152.
 */
package org.brickred.socialauth.cdi;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.apache.log4j.Logger;
import org.brickred.socialauth.AuthProvider;
import org.brickred.socialauth.AuthProviderFactory;
import org.brickred.socialauth.Contact;
import org.brickred.socialauth.Profile;
import org.brickred.socialauth.SocialAuthConfig;
import org.brickred.socialauth.SocialAuthManager;
import org.brickred.socialauth.util.SocialAuthUtil;

@Named(value="socialauth")
@SessionScoped
public class SocialAuth
implements Serializable {
    private static final long serialVersionUID = 1789108831048043099L;
    private static final Logger log = Logger.getLogger(SocialAuth.class);
    private String id;
    private Profile profile;
    private AuthProvider provider;
    private String status;
    private String viewUrl;
    private SocialAuthManager manager;
    private SocialAuthConfig config;

    public void init() {
        this.id = null;
        this.provider = null;
        this.config = new SocialAuthConfig();
        try {
            this.config.load();
            this.manager = new SocialAuthManager();
            this.manager.setSocialAuthConfig(this.config);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public SocialAuth() {
        this.init();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setViewUrl(String viewUrl) {
        this.viewUrl = viewUrl;
    }

    public String getViewUrl() {
        return this.viewUrl;
    }

    private String returnToUrl() throws MalformedURLException {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletRequest request = (HttpServletRequest)context.getExternalContext().getRequest();
        URL returnToUrl = request.getServerPort() == 80 ? new URL("http", request.getServerName(), context.getApplication().getViewHandler().getActionURL(context, this.viewUrl)) : new URL("http", request.getServerName(), request.getServerPort(), context.getApplication().getViewHandler().getActionURL(context, this.viewUrl));
        return returnToUrl.toExternalForm();
    }

    public void login() throws Exception {
        this.provider = AuthProviderFactory.getInstance((String)this.id);
        String returnToUrl = this.returnToUrl();
        String url = this.manager.getAuthenticationUrl(this.id, returnToUrl);
        log.info((Object)("Redirecting to:" + url));
        if (url != null) {
            FacesContext.getCurrentInstance().getExternalContext().redirect(url);
        }
    }

    public void connect() throws Exception {
        log.info((Object)("Connecting Provider:" + this.id));
        ExternalContext context = FacesContext.getCurrentInstance().getExternalContext();
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        this.provider = this.manager.connect(SocialAuthUtil.getRequestParametersMap((HttpServletRequest)request));
        this.profile = this.provider.getUserProfile();
    }

    public void logout() {
        this.init();
    }

    public Profile getProfile() {
        return this.profile;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void updateStatus() throws Exception {
        this.provider.updateStatus(this.status);
    }

    public List<Contact> getContactList() throws Exception {
        return this.provider.getContactList();
    }

    public Profile getUserProfile() throws Exception {
        return this.provider.getUserProfile();
    }
}

