/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.bremersee.comparator.model.SortOrdersTextProperties;

@XmlRootElement(name="sortOrder")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="sortOrderType", propOrder={"field", "asc", "ignoreCase", "nullIsFirst"})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"field", "asc", "ignoreCase", "nullIsFirst"})
@Schema(description="A sort order defines how a field of an object is sorted.")
public class SortOrder {
    @Schema(description="The field name or path.")
    @XmlElement(name="field")
    private final String field;
    @Schema(description="Is ascending or descending order.", requiredMode=Schema.RequiredMode.REQUIRED)
    @XmlElement(name="asc", defaultValue="true")
    private final boolean asc;
    @Schema(description="Is case insensitive or sensitive order.", requiredMode=Schema.RequiredMode.REQUIRED)
    @XmlElement(name="ignoreCase", defaultValue="true")
    private final boolean ignoreCase;
    @Schema(description="Is null is first.", requiredMode=Schema.RequiredMode.REQUIRED)
    @XmlElement(name="nullIsFirst", defaultValue="false")
    private final boolean nullIsFirst;

    protected SortOrder() {
        this(null, true, true, false);
    }

    @JsonCreator
    public SortOrder(@JsonProperty(value="field") String field, @JsonProperty(value="asc", required=true) boolean asc, @JsonProperty(value="ignoreCase", required=true) boolean ignoreCase, @JsonProperty(value="nullIsFirst", required=true) boolean nullIsFirst) {
        this.field = field;
        this.asc = asc;
        this.ignoreCase = ignoreCase;
        this.nullIsFirst = nullIsFirst;
    }

    public SortOrder with(Direction direction) {
        return Optional.ofNullable(direction).map(dir -> new SortOrder(this.getField(), dir.isAsc(), this.isIgnoreCase(), this.isNullIsFirst())).orElse(this);
    }

    public SortOrder with(CaseHandling caseHandling) {
        return Optional.ofNullable(caseHandling).map(ch -> new SortOrder(this.getField(), this.isAsc(), ch.isIgnoreCase(), this.isNullIsFirst())).orElse(this);
    }

    public SortOrder with(NullHandling nullHandling) {
        return Optional.ofNullable(nullHandling).map(nh -> new SortOrder(this.getField(), this.isAsc(), this.isIgnoreCase(), nh.isNullIsFirst())).orElse(this);
    }

    @JsonIgnore
    @XmlTransient
    public String getSortOrderText() {
        return this.getSortOrderText(null);
    }

    @Deprecated
    public String toSortOrderText() {
        return this.getSortOrderText();
    }

    public String getSortOrderText(SortOrdersTextProperties properties) {
        SortOrdersTextProperties props = Objects.requireNonNullElse(properties, SortOrdersTextProperties.defaults());
        return (this.field != null ? this.field : "") + props.getSortOrderArgsSeparator() + props.getDirectionValue(this.asc) + props.getSortOrderArgsSeparator() + props.getIgnoreCaseValue(this.ignoreCase) + props.getSortOrderArgsSeparator() + props.getNullIsFirstValue(this.nullIsFirst);
    }

    @Deprecated
    public String toSortOrderText(SortOrdersTextProperties properties) {
        return this.getSortOrderText(properties);
    }

    public String toString() {
        return this.getSortOrderText();
    }

    public static SortOrder by(String field) {
        return new SortOrder(field, true, true, false);
    }

    public static SortOrder fromSortOrderText(String source) {
        return SortOrder.fromSortOrderText(source, SortOrdersTextProperties.defaults());
    }

    public static SortOrder fromSortOrderText(String source, SortOrdersTextProperties properties) {
        return Optional.ofNullable(source).map(text -> {
            String field;
            SortOrdersTextProperties props = Objects.requireNonNullElse(properties, SortOrdersTextProperties.defaults());
            boolean asc = props.isAsc(null);
            boolean ignoreCase = props.isCaseIgnored(null);
            boolean nullIsFirst = props.isNullFirst(null);
            String separator = props.getSortOrderArgsSeparator();
            int index = text.indexOf(separator);
            if (index < 0) {
                field = text.trim();
            } else {
                field = text.substring(0, index).trim();
                int from = index + separator.length();
                if ((index = text.indexOf(separator, from)) < 0) {
                    asc = props.isAsc(text.substring(from).trim());
                } else {
                    asc = props.isAsc(text.substring(from, index).trim());
                    from = index + separator.length();
                    if ((index = text.indexOf(separator, from)) < 0) {
                        ignoreCase = props.isCaseIgnored(text.substring(from).trim());
                    } else {
                        ignoreCase = props.isCaseIgnored(text.substring(from, index).trim());
                        from = index + separator.length();
                        nullIsFirst = props.isNullFirst(text.substring(from).trim());
                    }
                }
            }
            field = field.isEmpty() ? null : field;
            return new SortOrder(field, asc, ignoreCase, nullIsFirst);
        }).orElseGet(() -> new SortOrder(null, true, true, false));
    }

    @Generated
    public String getField() {
        return this.field;
    }

    @Generated
    public boolean isAsc() {
        return this.asc;
    }

    @Generated
    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    @Generated
    public boolean isNullIsFirst() {
        return this.nullIsFirst;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortOrder)) {
            return false;
        }
        SortOrder other = (SortOrder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAsc() != other.isAsc()) {
            return false;
        }
        if (this.isIgnoreCase() != other.isIgnoreCase()) {
            return false;
        }
        if (this.isNullIsFirst() != other.isNullIsFirst()) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        return !(this$field == null ? other$field != null : !this$field.equals(other$field));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SortOrder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAsc() ? 79 : 97);
        result = result * 59 + (this.isIgnoreCase() ? 79 : 97);
        result = result * 59 + (this.isNullIsFirst() ? 79 : 97);
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        return result;
    }

    public static enum NullHandling {
        NULLS_FIRST,
        NULLS_LAST;


        public boolean isNullIsFirst() {
            return NULLS_FIRST.equals((Object)this);
        }
    }

    public static enum CaseHandling {
        INSENSITIVE,
        SENSITIVE;


        public boolean isIgnoreCase() {
            return INSENSITIVE.equals((Object)this);
        }
    }

    public static enum Direction {
        ASC,
        DESC;


        public boolean isAsc() {
            return ASC.equals((Object)this);
        }
    }
}

