/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator;

import java.util.Comparator;
import lombok.Generated;
import org.bremersee.comparator.ComparatorException;
import org.bremersee.comparator.DefaultValueExtractor;
import org.bremersee.comparator.ValueExtractor;
import org.bremersee.comparator.model.SortOrder;

public class ValueComparator
implements Comparator<Object> {
    private final ValueExtractor valueExtractor;
    private final String field;
    private final boolean asc;
    private final boolean ignoreCase;
    private final boolean nullIsFirst;

    public ValueComparator(SortOrder sortOrder) {
        this(sortOrder.getField(), sortOrder.isAsc(), sortOrder.isIgnoreCase(), sortOrder.isNullIsFirst(), null);
    }

    public ValueComparator(SortOrder sortOrder, ValueExtractor valueExtractor) {
        this(sortOrder.getField(), sortOrder.isAsc(), sortOrder.isIgnoreCase(), sortOrder.isNullIsFirst(), valueExtractor);
    }

    public ValueComparator(String field, boolean asc, boolean ignoreCase, boolean nullIsFirst) {
        this(field, asc, ignoreCase, nullIsFirst, null);
    }

    public ValueComparator(String field, boolean asc, boolean ignoreCase, boolean nullIsFirst, ValueExtractor valueExtractor) {
        this.field = field;
        this.asc = asc;
        this.ignoreCase = ignoreCase;
        this.nullIsFirst = nullIsFirst;
        this.valueExtractor = valueExtractor != null ? valueExtractor : new DefaultValueExtractor();
    }

    @Override
    public int compare(Object o1, Object o2) {
        Object v1 = this.valueExtractor.findValue(o1, this.field);
        Object v2 = this.valueExtractor.findValue(o2, this.field);
        if (v1 == null && v2 == null) {
            return 0;
        }
        if (v1 == null) {
            if (this.asc) {
                return this.nullIsFirst ? -1 : 1;
            }
            return this.nullIsFirst ? 1 : -1;
        }
        if (v2 == null) {
            if (this.asc) {
                return this.nullIsFirst ? 1 : -1;
            }
            return this.nullIsFirst ? -1 : 1;
        }
        if (this.asc && v1 instanceof Comparable) {
            if (this.ignoreCase && v1 instanceof String && v2 instanceof String) {
                return ((String)v1).compareToIgnoreCase((String)v2);
            }
            return ((Comparable)v1).compareTo(v2);
        }
        if (!this.asc && v2 instanceof Comparable) {
            if (this.ignoreCase && v1 instanceof String && v2 instanceof String) {
                return ((String)v2).compareToIgnoreCase((String)v1);
            }
            return ((Comparable)v2).compareTo(v1);
        }
        throw new ComparatorException("Comparison of field '" + this.field + "' is not possible.");
    }

    @Generated
    public String toString() {
        return "ValueComparator(valueExtractor=" + this.valueExtractor + ", field=" + this.field + ", asc=" + this.asc + ", ignoreCase=" + this.ignoreCase + ", nullIsFirst=" + this.nullIsFirst + ")";
    }
}

