/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import lombok.Generated;
import org.bremersee.comparator.ValueExtractor;
import org.bremersee.comparator.ValueExtractorException;

public class DefaultValueExtractor
implements ValueExtractor {
    private final boolean throwingException;

    public DefaultValueExtractor() {
        this(true);
    }

    public DefaultValueExtractor(boolean throwingException) {
        this.throwingException = throwingException;
    }

    @Override
    public Object findValue(Object obj, String fieldPath) {
        Object value;
        String fieldIdentifier = DefaultValueExtractor.trimFieldPath(fieldPath);
        if (obj == null || fieldIdentifier == null || fieldIdentifier.isEmpty()) {
            return obj;
        }
        int index = fieldIdentifier.indexOf(46);
        String fieldName = index < 0 ? fieldIdentifier : fieldIdentifier.substring(0, index).trim();
        Optional<Field> field = this.findField(obj.getClass(), fieldName);
        if (field.isPresent()) {
            value = this.invoke(field.get(), obj);
        } else {
            Optional<Method> method = this.findMethod(obj.getClass(), fieldName);
            if (method.isPresent()) {
                value = this.invoke(method.get(), obj);
            } else {
                if (this.throwingException) {
                    throw new ValueExtractorException("Field [" + fieldName + "] was not found on object [" + obj + "].");
                }
                value = null;
            }
        }
        return index < 0 ? value : this.findValue(value, fieldIdentifier.substring(index + 1));
    }

    private static String trimFieldPath(String field) {
        if (field == null) {
            return null;
        }
        String tmp = field.replace("..", ".").trim();
        while (tmp.startsWith(".")) {
            tmp = tmp.substring(1).trim();
        }
        while (tmp.endsWith(".")) {
            tmp = tmp.substring(0, tmp.length() - 1).trim();
        }
        return tmp;
    }

    @Generated
    public String toString() {
        return "DefaultValueExtractor(throwingException=" + this.throwingException + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultValueExtractor)) {
            return false;
        }
        DefaultValueExtractor other = (DefaultValueExtractor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.throwingException == other.throwingException;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultValueExtractor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.throwingException ? 79 : 97);
        return result;
    }
}

