/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.bremersee.comparator.model.SortOrder;
import org.bremersee.comparator.model.SortOrdersTextProperties;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="sortOrders")
@XmlType(name="sortOrdersType")
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="A list of sort orders.")
public class SortOrders {
    @Schema(description="The list of sort orders.")
    @XmlElementRef
    private final List<SortOrder> sortOrders = new ArrayList<SortOrder>();

    protected SortOrders() {
    }

    @JsonCreator
    public SortOrders(@JsonProperty(value="sortOrders") Collection<? extends SortOrder> sortOrders) {
        if (sortOrders != null) {
            this.sortOrders.addAll(sortOrders);
        }
    }

    public List<SortOrder> getSortOrders() {
        return Collections.unmodifiableList(this.sortOrders);
    }

    @XmlTransient
    @JsonIgnore
    public boolean isEmpty() {
        return this.sortOrders.isEmpty();
    }

    @XmlTransient
    @JsonIgnore
    public boolean isSorted() {
        return !this.isEmpty();
    }

    @XmlTransient
    @JsonIgnore
    public boolean isUnsorted() {
        return !this.isSorted();
    }

    @JsonIgnore
    @XmlTransient
    public String getSortOrdersText() {
        return this.getSortOrdersText(null);
    }

    @Deprecated
    public String toSortOrdersText() {
        return this.getSortOrdersText();
    }

    public String getSortOrdersText(SortOrdersTextProperties properties) {
        SortOrdersTextProperties props = Objects.requireNonNullElse(properties, SortOrdersTextProperties.defaults());
        return this.sortOrders.stream().map(sortOrder -> sortOrder.getSortOrderText(props)).collect(Collectors.joining(props.getSortOrderSeparator()));
    }

    @Deprecated
    public String toSortOrdersText(SortOrdersTextProperties properties) {
        return this.getSortOrdersText(properties);
    }

    public String toString() {
        return this.getSortOrdersText();
    }

    public static SortOrders fromSortOrdersText(String source) {
        return SortOrders.fromSortOrdersText(source, SortOrdersTextProperties.defaults());
    }

    public static SortOrders fromSortOrdersText(String source, SortOrdersTextProperties properties) {
        return Optional.ofNullable(source).map(text -> {
            SortOrdersTextProperties props = Objects.requireNonNullElse(properties, SortOrdersTextProperties.defaults());
            ArrayList<SortOrder> sortOrders = new ArrayList<SortOrder>();
            StringTokenizer tokenizer = new StringTokenizer((String)text, props.getSortOrderSeparator());
            while (tokenizer.hasMoreTokens()) {
                sortOrders.add(SortOrder.fromSortOrderText(tokenizer.nextToken(), props));
            }
            return new SortOrders(sortOrders);
        }).orElseGet(SortOrders::new);
    }

    public static SortOrders by(SortOrder ... sortOrders) {
        return Optional.ofNullable(sortOrders).map(so -> new SortOrders(Arrays.asList(so))).orElseGet(SortOrders::new);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SortOrders)) {
            return false;
        }
        SortOrders other = (SortOrders)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<SortOrder> this$sortOrders = this.getSortOrders();
        List<SortOrder> other$sortOrders = other.getSortOrders();
        return !(this$sortOrders == null ? other$sortOrders != null : !((Object)this$sortOrders).equals(other$sortOrders));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SortOrders;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<SortOrder> $sortOrders = this.getSortOrders();
        result = result * 59 + ($sortOrders == null ? 43 : ((Object)$sortOrders).hashCode());
        return result;
    }
}

