/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator.spring.mapper;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.bremersee.comparator.model.SortOrder;
import org.bremersee.comparator.model.SortOrders;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.Streamable;
import org.springframework.util.ObjectUtils;

public abstract class SortMapper {
    private SortMapper() {
    }

    public static Sort toSort(SortOrders sortOrders) {
        return SortMapper.toSort(sortOrders != null ? sortOrders.getSortOrders() : null);
    }

    public static Sort toSort(List<? extends SortOrder> sortOrders) {
        List orderList = Optional.ofNullable(sortOrders).stream().flatMap(Collection::stream).map(SortMapper::toSortOrder).filter(Objects::nonNull).collect(Collectors.toList());
        return orderList.isEmpty() ? Sort.unsorted() : Sort.by(orderList);
    }

    public static List<SortOrder> fromSort(Sort sort) {
        return Optional.ofNullable(sort).stream().flatMap(Streamable::stream).map(SortMapper::fromSortOrder).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
    }

    public static Sort.Order toSortOrder(SortOrder sortOrder) {
        if (sortOrder == null || sortOrder.getField() == null || sortOrder.getField().trim().length() == 0) {
            return null;
        }
        Sort.Direction direction = sortOrder.isAsc() ? Sort.Direction.ASC : Sort.Direction.DESC;
        Sort.NullHandling nullHandlingHint = sortOrder.isNullIsFirst() ? Sort.NullHandling.NULLS_FIRST : Sort.NullHandling.NULLS_LAST;
        Sort.Order order = new Sort.Order(direction, sortOrder.getField(), nullHandlingHint);
        return sortOrder.isIgnoreCase() ? order.ignoreCase() : order;
    }

    public static SortOrder fromSortOrder(Sort.Order sortOrder) {
        if (sortOrder == null) {
            return null;
        }
        boolean nullIsFirst = Sort.NullHandling.NULLS_FIRST.equals((Object)sortOrder.getNullHandling());
        return new SortOrder(sortOrder.getProperty(), sortOrder.isAscending(), sortOrder.isIgnoreCase(), nullIsFirst);
    }

    public static Sort applyDefaults(Sort source, Boolean asc, Boolean ignoreCase, Boolean nullIsFirst, String ... properties) {
        if (Objects.isNull(source)) {
            return Sort.unsorted();
        }
        if (Objects.isNull(asc) && Objects.isNull(ignoreCase) && Objects.isNull(nullIsFirst)) {
            return source;
        }
        Set names = ObjectUtils.isEmpty((Object[])properties) ? source.stream().map(Sort.Order::getProperty).collect(Collectors.toSet()) : Arrays.stream(properties).collect(Collectors.toSet());
        return Sort.by(source.stream().map(sortOrder -> {
            if (names.contains(sortOrder.getProperty())) {
                Sort.Order order = Sort.Order.by((String)sortOrder.getProperty()).with(SortMapper.newDirection(sortOrder.getDirection(), asc)).with(SortMapper.newNullHandling(sortOrder.getNullHandling(), nullIsFirst));
                return SortMapper.withNewCaseHandling(order, sortOrder.isIgnoreCase(), ignoreCase);
            }
            return sortOrder;
        }).collect(Collectors.toList()));
    }

    private static Sort.Direction newDirection(Sort.Direction oldDirection, Boolean asc) {
        return Optional.ofNullable(asc).map(isAsc -> isAsc != false ? Sort.Direction.ASC : Sort.Direction.DESC).orElse(oldDirection);
    }

    private static Sort.NullHandling newNullHandling(Sort.NullHandling oldNullHandling, Boolean nullIsFirst) {
        return Optional.ofNullable(nullIsFirst).map(isNullIsFirst -> isNullIsFirst != false ? Sort.NullHandling.NULLS_FIRST : Sort.NullHandling.NULLS_LAST).orElse(oldNullHandling);
    }

    private static Sort.Order withNewCaseHandling(Sort.Order order, boolean oldIgnoresCase, Boolean newIgnoresCase) {
        return Optional.ofNullable(newIgnoresCase).map(ignoreCase -> ignoreCase != false ? order.ignoreCase() : order).orElseGet(() -> oldIgnoresCase ? order.ignoreCase() : order);
    }
}

