/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import org.bremersee.comparator.ComparatorChain;
import org.bremersee.comparator.DelegatingComparator;
import org.bremersee.comparator.ValueComparator;
import org.bremersee.comparator.ValueExtractor;
import org.bremersee.comparator.model.SortOrder;
import org.bremersee.comparator.model.SortOrders;

public interface ComparatorBuilder {
    public static ComparatorBuilder builder() {
        return new DefaultComparatorBuilder();
    }

    public ComparatorBuilder add(Comparator<?> var1);

    default public ComparatorBuilder add(String field) {
        return this.add(field, true, true, false);
    }

    default public ComparatorBuilder add(String field, Comparator<?> comparator) {
        return this.add(field, null, comparator);
    }

    default public ComparatorBuilder add(String field, ValueExtractor valueExtractor, Comparator<?> comparator) {
        return Optional.ofNullable(comparator).map(c -> this.add(new DelegatingComparator(field, valueExtractor, (Comparator<?>)c))).orElse(this);
    }

    default public ComparatorBuilder add(String field, boolean asc, boolean ignoreCase, boolean nullIsFirst) {
        return this.add(field, asc, ignoreCase, nullIsFirst, null);
    }

    default public ComparatorBuilder add(String field, boolean asc, boolean ignoreCase, boolean nullIsFirst, ValueExtractor valueExtractor) {
        return this.add(new ValueComparator(field, asc, ignoreCase, nullIsFirst, valueExtractor));
    }

    default public ComparatorBuilder add(SortOrder field) {
        return this.add(field, null);
    }

    default public ComparatorBuilder add(SortOrder field, ValueExtractor valueExtractor) {
        return Optional.ofNullable(field).map(sortOrder -> this.add(sortOrder.getField(), sortOrder.isAsc(), sortOrder.isIgnoreCase(), sortOrder.isNullIsFirst(), valueExtractor)).orElse(this);
    }

    default public ComparatorBuilder addAll(Collection<? extends SortOrder> sortOrders) {
        return this.addAll(sortOrders, (ValueExtractor)null);
    }

    default public ComparatorBuilder addAll(Collection<? extends SortOrder> sortOrders, ValueExtractor valueExtractor) {
        Optional.ofNullable(sortOrders).ifPresent(orders -> orders.stream().filter(Objects::nonNull).forEach(sortOrder -> this.add((SortOrder)sortOrder, valueExtractor)));
        return this;
    }

    default public ComparatorBuilder addAll(Collection<? extends SortOrder> sortOrders, Function<SortOrder, Comparator<?>> comparatorFunction) {
        Optional.ofNullable(sortOrders).ifPresent(orders -> orders.stream().filter(Objects::nonNull).forEach(sortOrder -> this.add((Comparator)comparatorFunction.apply((SortOrder)sortOrder))));
        return this;
    }

    default public ComparatorBuilder addAll(SortOrders sortOrders) {
        return Optional.ofNullable(sortOrders).map(orders -> this.addAll(orders.getSortOrders())).orElse(this);
    }

    default public ComparatorBuilder addAll(SortOrders sortOrders, ValueExtractor valueExtractor) {
        return Optional.ofNullable(sortOrders).map(orders -> this.addAll(orders.getSortOrders(), valueExtractor)).orElse(this);
    }

    default public ComparatorBuilder addAll(SortOrders sortOrders, Function<SortOrder, Comparator<?>> comparatorFunction) {
        return Optional.ofNullable(sortOrders).map(orders -> this.addAll(orders.getSortOrders(), comparatorFunction)).orElse(this);
    }

    public <T> Comparator<T> build();

    public static class DefaultComparatorBuilder
    implements ComparatorBuilder {
        private final List<Comparator> comparatorChain = new LinkedList<Comparator>();

        @Override
        public ComparatorBuilder add(Comparator<?> comparator) {
            Optional.ofNullable(comparator).ifPresent(this.comparatorChain::add);
            return this;
        }

        @Override
        public <T> Comparator<T> build() {
            return new ComparatorChain(this.comparatorChain);
        }
    }
}

