/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator.model;

import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.bremersee.comparator.model.ImmutableWellKnownTextProperties;
import org.immutables.value.Value;

@Valid
@Value.Immutable
public interface WellKnownTextProperties {
    public static ImmutableWellKnownTextProperties.Builder builder() {
        return ImmutableWellKnownTextProperties.builder();
    }

    public static WellKnownTextProperties defaults() {
        return WellKnownTextProperties.builder().build();
    }

    @NotEmpty
    @Value.Default
    default public String getFieldSeparator() {
        return ";";
    }

    @NotEmpty
    @Value.Default
    default public String getFieldArgsSeparator() {
        return ",";
    }

    @NotEmpty
    @Value.Default
    default public String getAscValue() {
        return "asc";
    }

    @NotEmpty
    @Value.Default
    default public String getDescValue() {
        return "desc";
    }

    @NotEmpty
    @Value.Derived
    default public String getDirectionValue(boolean asc) {
        return asc ? this.getAscValue() : this.getDescValue();
    }

    @Value.Derived
    default public boolean isAsc(String value) {
        return value == null || value.trim().length() == 0 || value.equalsIgnoreCase(this.getAscValue());
    }

    @NotEmpty
    @Value.Default
    default public String getCaseInsensitiveValue() {
        return "true";
    }

    @NotEmpty
    @Value.Default
    default public String getCaseSensitiveValue() {
        return "false";
    }

    @NotEmpty
    @Value.Derived
    default public String getIgnoreCaseValue(boolean ignoreCase) {
        return ignoreCase ? this.getCaseInsensitiveValue() : this.getCaseSensitiveValue();
    }

    @Value.Derived
    default public boolean isCaseIgnored(String value) {
        return value == null || value.trim().length() == 0 || value.equalsIgnoreCase(this.getCaseInsensitiveValue());
    }

    @NotEmpty
    @Value.Default
    default public String getNullIsLastValue() {
        return "false";
    }

    @NotEmpty
    @Value.Default
    default public String getNullIsFirstValue() {
        return "true";
    }

    @NotEmpty
    @Value.Derived
    default public String getNullIsFirstValue(boolean nullIsFirst) {
        return nullIsFirst ? this.getNullIsFirstValue() : this.getNullIsLastValue();
    }

    @Value.Derived
    default public boolean isNullFirst(String value) {
        return this.getNullIsFirstValue().equalsIgnoreCase(value);
    }
}

