/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import lombok.Generated;
import org.bremersee.comparator.model.ComparatorField;
import org.bremersee.comparator.model.WellKnownTextProperties;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="comparatorFields")
@XmlType(name="comparatorFieldsType")
@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(description="A list of comparator fields.")
@Valid
public class ComparatorFields {
    @Schema(description="The list of comparator fields.")
    private List<ComparatorField> fields = new ArrayList<ComparatorField>();

    public ComparatorFields() {
    }

    @JsonCreator
    public ComparatorFields(@JsonProperty(value="fields") Collection<? extends ComparatorField> fields) {
        if (fields != null) {
            this.fields.addAll(fields);
        }
    }

    public List<ComparatorField> getFields() {
        return this.fields;
    }

    @NotEmpty
    public String toWkt() {
        return this.toWkt(null);
    }

    @NotEmpty
    public String toWkt(WellKnownTextProperties properties) {
        WellKnownTextProperties props = Objects.requireNonNullElse(properties, WellKnownTextProperties.defaults());
        return this.fields.stream().map(comparatorField -> comparatorField.toWkt(props)).collect(Collectors.joining(props.getFieldSeparator()));
    }

    public String toString() {
        return this.toWkt();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComparatorFields)) {
            return false;
        }
        ComparatorFields other = (ComparatorFields)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ComparatorField> this$fields = this.getFields();
        List<ComparatorField> other$fields = other.getFields();
        return !(this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComparatorFields;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ComparatorField> $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        return result;
    }
}

