/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import lombok.Generated;
import org.bremersee.comparator.model.WellKnownTextProperties;

@XmlRootElement(name="comparatorField")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="comparatorFieldType", propOrder={"field", "asc", "ignoreCase", "nullIsFirst"})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"field", "asc", "ignoreCase", "nullIsFirst"})
@Schema(description="A comparator field defines how a field of an object is sorted.")
@Valid
public class ComparatorField {
    @Schema(description="The field name or path.")
    @XmlElement(name="field")
    private String field;
    @Schema(description="Is ascending or descending order.", required=true)
    @XmlElement(name="asc", defaultValue="true")
    private boolean asc;
    @Schema(description="Is case insensitive or sensitive order.", required=true)
    @XmlElement(name="ignoreCase", defaultValue="true")
    private boolean ignoreCase;
    @Schema(description="Is null is first.", required=true)
    @XmlElement(name="nullIsFirst", defaultValue="false")
    private boolean nullIsFirst;

    public ComparatorField() {
        this(null, true, true, false);
    }

    @JsonCreator
    public ComparatorField(@JsonProperty(value="field") String field, @JsonProperty(value="asc", required=true) boolean asc, @JsonProperty(value="ignoreCase", required=true) boolean ignoreCase, @JsonProperty(value="nullIsFirst", required=true) boolean nullIsFirst) {
        this.field = field;
        this.asc = asc;
        this.ignoreCase = ignoreCase;
        this.nullIsFirst = nullIsFirst;
    }

    public String getField() {
        return this.field;
    }

    public boolean isAsc() {
        return this.asc;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isNullIsFirst() {
        return this.nullIsFirst;
    }

    @NotEmpty
    public String toWkt() {
        return this.toWkt(null);
    }

    @NotEmpty
    public String toWkt(WellKnownTextProperties properties) {
        WellKnownTextProperties props = Objects.requireNonNullElse(properties, WellKnownTextProperties.defaults());
        return (this.field != null ? this.field : "") + props.getFieldArgsSeparator() + props.getDirectionValue(this.asc) + props.getFieldArgsSeparator() + props.getIgnoreCaseValue(this.ignoreCase) + props.getFieldArgsSeparator() + props.getNullIsFirstValue(this.nullIsFirst);
    }

    public String toString() {
        return this.toWkt();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComparatorField)) {
            return false;
        }
        ComparatorField other = (ComparatorField)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAsc() != other.isAsc()) {
            return false;
        }
        if (this.isIgnoreCase() != other.isIgnoreCase()) {
            return false;
        }
        if (this.isNullIsFirst() != other.isNullIsFirst()) {
            return false;
        }
        String this$field = this.getField();
        String other$field = other.getField();
        return !(this$field == null ? other$field != null : !this$field.equals(other$field));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ComparatorField;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAsc() ? 79 : 97);
        result = result * 59 + (this.isIgnoreCase() ? 79 : 97);
        result = result * 59 + (this.isNullIsFirst() ? 79 : 97);
        String $field = this.getField();
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        return result;
    }
}

