/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.Function;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.bremersee.comparator.ComparatorBuilder;
import org.bremersee.comparator.model.ComparatorField;
import org.bremersee.comparator.model.WellKnownTextProperties;

@Valid
public interface WellKnownTextParser {
    @NotNull
    default public WellKnownTextProperties getProperties() {
        return WellKnownTextProperties.defaults();
    }

    @NotNull
    default public Comparator<Object> parse(String wkt) {
        ComparatorBuilder builder = ComparatorBuilder.builder();
        for (ComparatorField comparatorField : this.buildComparatorFields(wkt)) {
            Comparator comparator = this.apply(comparatorField);
            if (comparator == null) continue;
            builder.add(comparator);
        }
        return builder.build();
    }

    @NotNull
    default public List<ComparatorField> buildComparatorFields(String wkt) {
        return Optional.ofNullable(wkt).map(text -> {
            ArrayList<ComparatorField> fields = new ArrayList<ComparatorField>();
            StringTokenizer tokenizer = new StringTokenizer((String)text, this.getProperties().getFieldSeparator());
            while (tokenizer.hasMoreTokens()) {
                fields.add(this.buildComparatorField(tokenizer.nextToken()));
            }
            return fields;
        }).orElseGet(List::of);
    }

    @NotNull
    default public ComparatorField buildComparatorField(String fieldDescription) {
        WellKnownTextProperties props = this.getProperties();
        String field = null;
        boolean asc = props.isAsc(null);
        boolean ignoreCase = props.isCaseIgnored(null);
        boolean nullIsFirst = props.isNullFirst(null);
        if (fieldDescription != null) {
            String separator = props.getFieldArgsSeparator();
            int index = fieldDescription.indexOf(separator);
            if (index < 0) {
                field = fieldDescription.trim();
            } else {
                field = fieldDescription.substring(0, index).trim();
                int from = index + separator.length();
                if ((index = fieldDescription.indexOf(separator, from)) < 0) {
                    asc = props.isAsc(fieldDescription.substring(from).trim());
                } else {
                    asc = props.isAsc(fieldDescription.substring(from, index).trim());
                    from = index + separator.length();
                    if ((index = fieldDescription.indexOf(separator, from)) < 0) {
                        ignoreCase = props.isCaseIgnored(fieldDescription.substring(from).trim());
                    } else {
                        ignoreCase = props.isCaseIgnored(fieldDescription.substring(from, index).trim());
                        from = index + separator.length();
                        nullIsFirst = props.isNullFirst(fieldDescription.substring(from).trim());
                    }
                }
            }
        }
        field = field == null || field.length() == 0 ? null : field;
        return new ComparatorField(field, asc, ignoreCase, nullIsFirst);
    }

    @NotNull
    public Comparator apply(ComparatorField var1);

    @NotNull
    public static WellKnownTextParser newInstance(@NotNull Function<ComparatorField, Comparator> comparatorFunction) {
        return WellKnownTextParser.newInstance(comparatorFunction, null);
    }

    @NotNull
    public static WellKnownTextParser newInstance(@NotNull Function<ComparatorField, Comparator> comparatorFunction, WellKnownTextProperties properties) {
        return new Impl(comparatorFunction, properties);
    }

    public static class Impl
    implements WellKnownTextParser {
        private final Function<ComparatorField, Comparator> comparatorFunction;
        private final WellKnownTextProperties properties;

        private Impl(Function<ComparatorField, Comparator> comparatorFunction, WellKnownTextProperties properties) {
            this.comparatorFunction = comparatorFunction;
            this.properties = Objects.requireNonNullElse(properties, WellKnownTextProperties.defaults());
        }

        @Override
        public WellKnownTextProperties getProperties() {
            return this.properties;
        }

        @Override
        public Comparator apply(ComparatorField comparatorField) {
            return this.comparatorFunction.apply(comparatorField);
        }
    }
}

