package org.bremersee.comparator.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link WellKnownTextProperties}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableWellKnownTextProperties.builder()}.
 */
@Generated(from = "WellKnownTextProperties", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class ImmutableWellKnownTextProperties
    implements WellKnownTextProperties {
  private final String fieldSeparator;
  private final String fieldArgsSeparator;
  private final String ascValue;
  private final String descValue;
  private final String caseInsensitiveValue;
  private final String caseSensitiveValue;
  private final String nullIsLastValue;
  private final String nullIsFirstValue;

  private ImmutableWellKnownTextProperties(ImmutableWellKnownTextProperties.Builder builder) {
    if (builder.fieldSeparator != null) {
      initShim.fieldSeparator(builder.fieldSeparator);
    }
    if (builder.fieldArgsSeparator != null) {
      initShim.fieldArgsSeparator(builder.fieldArgsSeparator);
    }
    if (builder.ascValue != null) {
      initShim.ascValue(builder.ascValue);
    }
    if (builder.descValue != null) {
      initShim.descValue(builder.descValue);
    }
    if (builder.caseInsensitiveValue != null) {
      initShim.caseInsensitiveValue(builder.caseInsensitiveValue);
    }
    if (builder.caseSensitiveValue != null) {
      initShim.caseSensitiveValue(builder.caseSensitiveValue);
    }
    if (builder.nullIsLastValue != null) {
      initShim.nullIsLastValue(builder.nullIsLastValue);
    }
    if (builder.nullIsFirstValue != null) {
      initShim.nullIsFirstValue(builder.nullIsFirstValue);
    }
    this.fieldSeparator = initShim.getFieldSeparator();
    this.fieldArgsSeparator = initShim.getFieldArgsSeparator();
    this.ascValue = initShim.getAscValue();
    this.descValue = initShim.getDescValue();
    this.caseInsensitiveValue = initShim.getCaseInsensitiveValue();
    this.caseSensitiveValue = initShim.getCaseSensitiveValue();
    this.nullIsLastValue = initShim.getNullIsLastValue();
    this.nullIsFirstValue = initShim.getNullIsFirstValue();
    this.initShim = null;
  }

  private ImmutableWellKnownTextProperties(
      String fieldSeparator,
      String fieldArgsSeparator,
      String ascValue,
      String descValue,
      String caseInsensitiveValue,
      String caseSensitiveValue,
      String nullIsLastValue,
      String nullIsFirstValue) {
    this.fieldSeparator = fieldSeparator;
    this.fieldArgsSeparator = fieldArgsSeparator;
    this.ascValue = ascValue;
    this.descValue = descValue;
    this.caseInsensitiveValue = caseInsensitiveValue;
    this.caseSensitiveValue = caseSensitiveValue;
    this.nullIsLastValue = nullIsLastValue;
    this.nullIsFirstValue = nullIsFirstValue;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "WellKnownTextProperties", generator = "Immutables")
  private final class InitShim {
    private byte fieldSeparatorBuildStage = STAGE_UNINITIALIZED;
    private String fieldSeparator;

    String getFieldSeparator() {
      if (fieldSeparatorBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fieldSeparatorBuildStage == STAGE_UNINITIALIZED) {
        fieldSeparatorBuildStage = STAGE_INITIALIZING;
        this.fieldSeparator = Objects.requireNonNull(getFieldSeparatorInitialize(), "fieldSeparator");
        fieldSeparatorBuildStage = STAGE_INITIALIZED;
      }
      return this.fieldSeparator;
    }

    void fieldSeparator(String fieldSeparator) {
      this.fieldSeparator = fieldSeparator;
      fieldSeparatorBuildStage = STAGE_INITIALIZED;
    }

    private byte fieldArgsSeparatorBuildStage = STAGE_UNINITIALIZED;
    private String fieldArgsSeparator;

    String getFieldArgsSeparator() {
      if (fieldArgsSeparatorBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fieldArgsSeparatorBuildStage == STAGE_UNINITIALIZED) {
        fieldArgsSeparatorBuildStage = STAGE_INITIALIZING;
        this.fieldArgsSeparator = Objects.requireNonNull(getFieldArgsSeparatorInitialize(), "fieldArgsSeparator");
        fieldArgsSeparatorBuildStage = STAGE_INITIALIZED;
      }
      return this.fieldArgsSeparator;
    }

    void fieldArgsSeparator(String fieldArgsSeparator) {
      this.fieldArgsSeparator = fieldArgsSeparator;
      fieldArgsSeparatorBuildStage = STAGE_INITIALIZED;
    }

    private byte ascValueBuildStage = STAGE_UNINITIALIZED;
    private String ascValue;

    String getAscValue() {
      if (ascValueBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (ascValueBuildStage == STAGE_UNINITIALIZED) {
        ascValueBuildStage = STAGE_INITIALIZING;
        this.ascValue = Objects.requireNonNull(getAscValueInitialize(), "ascValue");
        ascValueBuildStage = STAGE_INITIALIZED;
      }
      return this.ascValue;
    }

    void ascValue(String ascValue) {
      this.ascValue = ascValue;
      ascValueBuildStage = STAGE_INITIALIZED;
    }

    private byte descValueBuildStage = STAGE_UNINITIALIZED;
    private String descValue;

    String getDescValue() {
      if (descValueBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (descValueBuildStage == STAGE_UNINITIALIZED) {
        descValueBuildStage = STAGE_INITIALIZING;
        this.descValue = Objects.requireNonNull(getDescValueInitialize(), "descValue");
        descValueBuildStage = STAGE_INITIALIZED;
      }
      return this.descValue;
    }

    void descValue(String descValue) {
      this.descValue = descValue;
      descValueBuildStage = STAGE_INITIALIZED;
    }

    private byte caseInsensitiveValueBuildStage = STAGE_UNINITIALIZED;
    private String caseInsensitiveValue;

    String getCaseInsensitiveValue() {
      if (caseInsensitiveValueBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (caseInsensitiveValueBuildStage == STAGE_UNINITIALIZED) {
        caseInsensitiveValueBuildStage = STAGE_INITIALIZING;
        this.caseInsensitiveValue = Objects.requireNonNull(getCaseInsensitiveValueInitialize(), "caseInsensitiveValue");
        caseInsensitiveValueBuildStage = STAGE_INITIALIZED;
      }
      return this.caseInsensitiveValue;
    }

    void caseInsensitiveValue(String caseInsensitiveValue) {
      this.caseInsensitiveValue = caseInsensitiveValue;
      caseInsensitiveValueBuildStage = STAGE_INITIALIZED;
    }

    private byte caseSensitiveValueBuildStage = STAGE_UNINITIALIZED;
    private String caseSensitiveValue;

    String getCaseSensitiveValue() {
      if (caseSensitiveValueBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (caseSensitiveValueBuildStage == STAGE_UNINITIALIZED) {
        caseSensitiveValueBuildStage = STAGE_INITIALIZING;
        this.caseSensitiveValue = Objects.requireNonNull(getCaseSensitiveValueInitialize(), "caseSensitiveValue");
        caseSensitiveValueBuildStage = STAGE_INITIALIZED;
      }
      return this.caseSensitiveValue;
    }

    void caseSensitiveValue(String caseSensitiveValue) {
      this.caseSensitiveValue = caseSensitiveValue;
      caseSensitiveValueBuildStage = STAGE_INITIALIZED;
    }

    private byte nullIsLastValueBuildStage = STAGE_UNINITIALIZED;
    private String nullIsLastValue;

    String getNullIsLastValue() {
      if (nullIsLastValueBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nullIsLastValueBuildStage == STAGE_UNINITIALIZED) {
        nullIsLastValueBuildStage = STAGE_INITIALIZING;
        this.nullIsLastValue = Objects.requireNonNull(getNullIsLastValueInitialize(), "nullIsLastValue");
        nullIsLastValueBuildStage = STAGE_INITIALIZED;
      }
      return this.nullIsLastValue;
    }

    void nullIsLastValue(String nullIsLastValue) {
      this.nullIsLastValue = nullIsLastValue;
      nullIsLastValueBuildStage = STAGE_INITIALIZED;
    }

    private byte nullIsFirstValueBuildStage = STAGE_UNINITIALIZED;
    private String nullIsFirstValue;

    String getNullIsFirstValue() {
      if (nullIsFirstValueBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (nullIsFirstValueBuildStage == STAGE_UNINITIALIZED) {
        nullIsFirstValueBuildStage = STAGE_INITIALIZING;
        this.nullIsFirstValue = Objects.requireNonNull(getNullIsFirstValueInitialize(), "nullIsFirstValue");
        nullIsFirstValueBuildStage = STAGE_INITIALIZED;
      }
      return this.nullIsFirstValue;
    }

    void nullIsFirstValue(String nullIsFirstValue) {
      this.nullIsFirstValue = nullIsFirstValue;
      nullIsFirstValueBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (fieldSeparatorBuildStage == STAGE_INITIALIZING) attributes.add("fieldSeparator");
      if (fieldArgsSeparatorBuildStage == STAGE_INITIALIZING) attributes.add("fieldArgsSeparator");
      if (ascValueBuildStage == STAGE_INITIALIZING) attributes.add("ascValue");
      if (descValueBuildStage == STAGE_INITIALIZING) attributes.add("descValue");
      if (caseInsensitiveValueBuildStage == STAGE_INITIALIZING) attributes.add("caseInsensitiveValue");
      if (caseSensitiveValueBuildStage == STAGE_INITIALIZING) attributes.add("caseSensitiveValue");
      if (nullIsLastValueBuildStage == STAGE_INITIALIZING) attributes.add("nullIsLastValue");
      if (nullIsFirstValueBuildStage == STAGE_INITIALIZING) attributes.add("nullIsFirstValue");
      return "Cannot build WellKnownTextProperties, attribute initializers form cycle " + attributes;
    }
  }

  private String getFieldSeparatorInitialize() {
    return WellKnownTextProperties.super.getFieldSeparator();
  }

  private String getFieldArgsSeparatorInitialize() {
    return WellKnownTextProperties.super.getFieldArgsSeparator();
  }

  private String getAscValueInitialize() {
    return WellKnownTextProperties.super.getAscValue();
  }

  private String getDescValueInitialize() {
    return WellKnownTextProperties.super.getDescValue();
  }

  private String getCaseInsensitiveValueInitialize() {
    return WellKnownTextProperties.super.getCaseInsensitiveValue();
  }

  private String getCaseSensitiveValueInitialize() {
    return WellKnownTextProperties.super.getCaseSensitiveValue();
  }

  private String getNullIsLastValueInitialize() {
    return WellKnownTextProperties.super.getNullIsLastValue();
  }

  private String getNullIsFirstValueInitialize() {
    return WellKnownTextProperties.super.getNullIsFirstValue();
  }

  /**
   * Gets field separator.
   * @return the field separator
   */
  @Override
  public String getFieldSeparator() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getFieldSeparator()
        : this.fieldSeparator;
  }

  /**
   * Gets field args separator.
   * @return the field args separator
   */
  @Override
  public String getFieldArgsSeparator() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getFieldArgsSeparator()
        : this.fieldArgsSeparator;
  }

  /**
   * Gets asc value.
   * @return the asc value
   */
  @Override
  public String getAscValue() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getAscValue()
        : this.ascValue;
  }

  /**
   * Gets desc value.
   * @return the desc value
   */
  @Override
  public String getDescValue() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDescValue()
        : this.descValue;
  }

  /**
   * Gets case insensitive value.
   * @return the case insensitive value
   */
  @Override
  public String getCaseInsensitiveValue() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCaseInsensitiveValue()
        : this.caseInsensitiveValue;
  }

  /**
   * Gets case sensitive value.
   * @return the case sensitive value
   */
  @Override
  public String getCaseSensitiveValue() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getCaseSensitiveValue()
        : this.caseSensitiveValue;
  }

  /**
   * Gets null is last value.
   * @return the null is last value
   */
  @Override
  public String getNullIsLastValue() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getNullIsLastValue()
        : this.nullIsLastValue;
  }

  /**
   * Gets null is first value.
   * @return the null is first value
   */
  @Override
  public String getNullIsFirstValue() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getNullIsFirstValue()
        : this.nullIsFirstValue;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WellKnownTextProperties#getFieldSeparator() fieldSeparator} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fieldSeparator
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWellKnownTextProperties withFieldSeparator(String value) {
    String newValue = Objects.requireNonNull(value, "fieldSeparator");
    if (this.fieldSeparator.equals(newValue)) return this;
    return new ImmutableWellKnownTextProperties(
        newValue,
        this.fieldArgsSeparator,
        this.ascValue,
        this.descValue,
        this.caseInsensitiveValue,
        this.caseSensitiveValue,
        this.nullIsLastValue,
        this.nullIsFirstValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WellKnownTextProperties#getFieldArgsSeparator() fieldArgsSeparator} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for fieldArgsSeparator
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWellKnownTextProperties withFieldArgsSeparator(String value) {
    String newValue = Objects.requireNonNull(value, "fieldArgsSeparator");
    if (this.fieldArgsSeparator.equals(newValue)) return this;
    return new ImmutableWellKnownTextProperties(
        this.fieldSeparator,
        newValue,
        this.ascValue,
        this.descValue,
        this.caseInsensitiveValue,
        this.caseSensitiveValue,
        this.nullIsLastValue,
        this.nullIsFirstValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WellKnownTextProperties#getAscValue() ascValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ascValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWellKnownTextProperties withAscValue(String value) {
    String newValue = Objects.requireNonNull(value, "ascValue");
    if (this.ascValue.equals(newValue)) return this;
    return new ImmutableWellKnownTextProperties(
        this.fieldSeparator,
        this.fieldArgsSeparator,
        newValue,
        this.descValue,
        this.caseInsensitiveValue,
        this.caseSensitiveValue,
        this.nullIsLastValue,
        this.nullIsFirstValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WellKnownTextProperties#getDescValue() descValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for descValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWellKnownTextProperties withDescValue(String value) {
    String newValue = Objects.requireNonNull(value, "descValue");
    if (this.descValue.equals(newValue)) return this;
    return new ImmutableWellKnownTextProperties(
        this.fieldSeparator,
        this.fieldArgsSeparator,
        this.ascValue,
        newValue,
        this.caseInsensitiveValue,
        this.caseSensitiveValue,
        this.nullIsLastValue,
        this.nullIsFirstValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WellKnownTextProperties#getCaseInsensitiveValue() caseInsensitiveValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for caseInsensitiveValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWellKnownTextProperties withCaseInsensitiveValue(String value) {
    String newValue = Objects.requireNonNull(value, "caseInsensitiveValue");
    if (this.caseInsensitiveValue.equals(newValue)) return this;
    return new ImmutableWellKnownTextProperties(
        this.fieldSeparator,
        this.fieldArgsSeparator,
        this.ascValue,
        this.descValue,
        newValue,
        this.caseSensitiveValue,
        this.nullIsLastValue,
        this.nullIsFirstValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WellKnownTextProperties#getCaseSensitiveValue() caseSensitiveValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for caseSensitiveValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWellKnownTextProperties withCaseSensitiveValue(String value) {
    String newValue = Objects.requireNonNull(value, "caseSensitiveValue");
    if (this.caseSensitiveValue.equals(newValue)) return this;
    return new ImmutableWellKnownTextProperties(
        this.fieldSeparator,
        this.fieldArgsSeparator,
        this.ascValue,
        this.descValue,
        this.caseInsensitiveValue,
        newValue,
        this.nullIsLastValue,
        this.nullIsFirstValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WellKnownTextProperties#getNullIsLastValue() nullIsLastValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullIsLastValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWellKnownTextProperties withNullIsLastValue(String value) {
    String newValue = Objects.requireNonNull(value, "nullIsLastValue");
    if (this.nullIsLastValue.equals(newValue)) return this;
    return new ImmutableWellKnownTextProperties(
        this.fieldSeparator,
        this.fieldArgsSeparator,
        this.ascValue,
        this.descValue,
        this.caseInsensitiveValue,
        this.caseSensitiveValue,
        newValue,
        this.nullIsFirstValue);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WellKnownTextProperties#getNullIsFirstValue() nullIsFirstValue} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for nullIsFirstValue
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableWellKnownTextProperties withNullIsFirstValue(String value) {
    String newValue = Objects.requireNonNull(value, "nullIsFirstValue");
    if (this.nullIsFirstValue.equals(newValue)) return this;
    return new ImmutableWellKnownTextProperties(
        this.fieldSeparator,
        this.fieldArgsSeparator,
        this.ascValue,
        this.descValue,
        this.caseInsensitiveValue,
        this.caseSensitiveValue,
        this.nullIsLastValue,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableWellKnownTextProperties} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableWellKnownTextProperties
        && equalTo((ImmutableWellKnownTextProperties) another);
  }

  private boolean equalTo(ImmutableWellKnownTextProperties another) {
    return fieldSeparator.equals(another.fieldSeparator)
        && fieldArgsSeparator.equals(another.fieldArgsSeparator)
        && ascValue.equals(another.ascValue)
        && descValue.equals(another.descValue)
        && caseInsensitiveValue.equals(another.caseInsensitiveValue)
        && caseSensitiveValue.equals(another.caseSensitiveValue)
        && nullIsLastValue.equals(another.nullIsLastValue)
        && nullIsFirstValue.equals(another.nullIsFirstValue);
  }

  /**
   * Computes a hash code from attributes: {@code fieldSeparator}, {@code fieldArgsSeparator}, {@code ascValue}, {@code descValue}, {@code caseInsensitiveValue}, {@code caseSensitiveValue}, {@code nullIsLastValue}, {@code nullIsFirstValue}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + fieldSeparator.hashCode();
    h += (h << 5) + fieldArgsSeparator.hashCode();
    h += (h << 5) + ascValue.hashCode();
    h += (h << 5) + descValue.hashCode();
    h += (h << 5) + caseInsensitiveValue.hashCode();
    h += (h << 5) + caseSensitiveValue.hashCode();
    h += (h << 5) + nullIsLastValue.hashCode();
    h += (h << 5) + nullIsFirstValue.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WellKnownTextProperties} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "WellKnownTextProperties{"
        + "fieldSeparator=" + fieldSeparator
        + ", fieldArgsSeparator=" + fieldArgsSeparator
        + ", ascValue=" + ascValue
        + ", descValue=" + descValue
        + ", caseInsensitiveValue=" + caseInsensitiveValue
        + ", caseSensitiveValue=" + caseSensitiveValue
        + ", nullIsLastValue=" + nullIsLastValue
        + ", nullIsFirstValue=" + nullIsFirstValue
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link WellKnownTextProperties} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WellKnownTextProperties instance
   */
  public static ImmutableWellKnownTextProperties copyOf(WellKnownTextProperties instance) {
    if (instance instanceof ImmutableWellKnownTextProperties) {
      return (ImmutableWellKnownTextProperties) instance;
    }
    return ImmutableWellKnownTextProperties.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableWellKnownTextProperties ImmutableWellKnownTextProperties}.
   * <pre>
   * ImmutableWellKnownTextProperties.builder()
   *    .fieldSeparator(String) // optional {@link WellKnownTextProperties#getFieldSeparator() fieldSeparator}
   *    .fieldArgsSeparator(String) // optional {@link WellKnownTextProperties#getFieldArgsSeparator() fieldArgsSeparator}
   *    .ascValue(String) // optional {@link WellKnownTextProperties#getAscValue() ascValue}
   *    .descValue(String) // optional {@link WellKnownTextProperties#getDescValue() descValue}
   *    .caseInsensitiveValue(String) // optional {@link WellKnownTextProperties#getCaseInsensitiveValue() caseInsensitiveValue}
   *    .caseSensitiveValue(String) // optional {@link WellKnownTextProperties#getCaseSensitiveValue() caseSensitiveValue}
   *    .nullIsLastValue(String) // optional {@link WellKnownTextProperties#getNullIsLastValue() nullIsLastValue}
   *    .nullIsFirstValue(String) // optional {@link WellKnownTextProperties#getNullIsFirstValue() nullIsFirstValue}
   *    .build();
   * </pre>
   * @return A new ImmutableWellKnownTextProperties builder
   */
  public static ImmutableWellKnownTextProperties.Builder builder() {
    return new ImmutableWellKnownTextProperties.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableWellKnownTextProperties ImmutableWellKnownTextProperties}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WellKnownTextProperties", generator = "Immutables")
  public static final class Builder {
    private String fieldSeparator;
    private String fieldArgsSeparator;
    private String ascValue;
    private String descValue;
    private String caseInsensitiveValue;
    private String caseSensitiveValue;
    private String nullIsLastValue;
    private String nullIsFirstValue;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WellKnownTextProperties} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(WellKnownTextProperties instance) {
      Objects.requireNonNull(instance, "instance");
      fieldSeparator(instance.getFieldSeparator());
      fieldArgsSeparator(instance.getFieldArgsSeparator());
      ascValue(instance.getAscValue());
      descValue(instance.getDescValue());
      caseInsensitiveValue(instance.getCaseInsensitiveValue());
      caseSensitiveValue(instance.getCaseSensitiveValue());
      nullIsLastValue(instance.getNullIsLastValue());
      nullIsFirstValue(instance.getNullIsFirstValue());
      return this;
    }

    /**
     * Initializes the value for the {@link WellKnownTextProperties#getFieldSeparator() fieldSeparator} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link WellKnownTextProperties#getFieldSeparator() fieldSeparator}.</em>
     * @param fieldSeparator The value for fieldSeparator 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fieldSeparator(String fieldSeparator) {
      this.fieldSeparator = Objects.requireNonNull(fieldSeparator, "fieldSeparator");
      return this;
    }

    /**
     * Initializes the value for the {@link WellKnownTextProperties#getFieldArgsSeparator() fieldArgsSeparator} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link WellKnownTextProperties#getFieldArgsSeparator() fieldArgsSeparator}.</em>
     * @param fieldArgsSeparator The value for fieldArgsSeparator 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder fieldArgsSeparator(String fieldArgsSeparator) {
      this.fieldArgsSeparator = Objects.requireNonNull(fieldArgsSeparator, "fieldArgsSeparator");
      return this;
    }

    /**
     * Initializes the value for the {@link WellKnownTextProperties#getAscValue() ascValue} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link WellKnownTextProperties#getAscValue() ascValue}.</em>
     * @param ascValue The value for ascValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder ascValue(String ascValue) {
      this.ascValue = Objects.requireNonNull(ascValue, "ascValue");
      return this;
    }

    /**
     * Initializes the value for the {@link WellKnownTextProperties#getDescValue() descValue} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link WellKnownTextProperties#getDescValue() descValue}.</em>
     * @param descValue The value for descValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder descValue(String descValue) {
      this.descValue = Objects.requireNonNull(descValue, "descValue");
      return this;
    }

    /**
     * Initializes the value for the {@link WellKnownTextProperties#getCaseInsensitiveValue() caseInsensitiveValue} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link WellKnownTextProperties#getCaseInsensitiveValue() caseInsensitiveValue}.</em>
     * @param caseInsensitiveValue The value for caseInsensitiveValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder caseInsensitiveValue(String caseInsensitiveValue) {
      this.caseInsensitiveValue = Objects.requireNonNull(caseInsensitiveValue, "caseInsensitiveValue");
      return this;
    }

    /**
     * Initializes the value for the {@link WellKnownTextProperties#getCaseSensitiveValue() caseSensitiveValue} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link WellKnownTextProperties#getCaseSensitiveValue() caseSensitiveValue}.</em>
     * @param caseSensitiveValue The value for caseSensitiveValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder caseSensitiveValue(String caseSensitiveValue) {
      this.caseSensitiveValue = Objects.requireNonNull(caseSensitiveValue, "caseSensitiveValue");
      return this;
    }

    /**
     * Initializes the value for the {@link WellKnownTextProperties#getNullIsLastValue() nullIsLastValue} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link WellKnownTextProperties#getNullIsLastValue() nullIsLastValue}.</em>
     * @param nullIsLastValue The value for nullIsLastValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nullIsLastValue(String nullIsLastValue) {
      this.nullIsLastValue = Objects.requireNonNull(nullIsLastValue, "nullIsLastValue");
      return this;
    }

    /**
     * Initializes the value for the {@link WellKnownTextProperties#getNullIsFirstValue() nullIsFirstValue} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link WellKnownTextProperties#getNullIsFirstValue() nullIsFirstValue}.</em>
     * @param nullIsFirstValue The value for nullIsFirstValue 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder nullIsFirstValue(String nullIsFirstValue) {
      this.nullIsFirstValue = Objects.requireNonNull(nullIsFirstValue, "nullIsFirstValue");
      return this;
    }

    /**
     * Builds a new {@link ImmutableWellKnownTextProperties ImmutableWellKnownTextProperties}.
     * @return An immutable instance of WellKnownTextProperties
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableWellKnownTextProperties build() {
      return new ImmutableWellKnownTextProperties(this);
    }
  }
}
