/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement(name="comparatorField")
@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="comparatorFieldType", propOrder={"field", "asc", "ignoreCase", "nullIsFirst"})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"field", "asc", "ignoreCase", "nullIsFirst"})
@Schema(description="A comparator field defines how a field of an object is sorted.")
public class ComparatorField {
    @Schema(description="The field name or path.")
    @XmlElement(name="field")
    private String field;
    @Schema(description="Is ascending or descending order.", required=true)
    @XmlElement(name="asc", defaultValue="true")
    private boolean asc = true;
    @Schema(description="Is case insensitive or sensitive order.", required=true)
    @XmlElement(name="ignoreCase", defaultValue="true")
    private boolean ignoreCase = true;
    @Schema(description="Is null is first.", required=true)
    @XmlElement(name="nullIsFirst", defaultValue="false")
    private boolean nullIsFirst = false;

    public ComparatorField() {
        this(null, true, true, false);
    }

    @JsonCreator
    public ComparatorField(@JsonProperty(value="field") String field, @JsonProperty(value="asc", required=true) boolean asc, @JsonProperty(value="ignoreCase", required=true) boolean ignoreCase, @JsonProperty(value="nullIsFirst", required=true) boolean nullIsFirst) {
        this.field = field;
        this.asc = asc;
        this.ignoreCase = ignoreCase;
        this.nullIsFirst = nullIsFirst;
    }

    public String getField() {
        return this.field;
    }

    public boolean isAsc() {
        return this.asc;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isNullIsFirst() {
        return this.nullIsFirst;
    }

    public String toWkt() {
        return (this.field != null ? this.field : "") + "," + (this.asc ? "asc," : "desc,") + this.ignoreCase + "," + this.nullIsFirst;
    }

    public String toString() {
        return this.toWkt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComparatorField)) {
            return false;
        }
        ComparatorField that = (ComparatorField)o;
        return this.asc == that.asc && this.ignoreCase == that.ignoreCase && this.nullIsFirst == that.nullIsFirst && Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.asc, this.ignoreCase, this.nullIsFirst);
    }
}

