/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.bremersee.comparator.ValueExtractorException;

public interface ValueExtractor {
    public Object findValue(Object var1, String var2);

    default public Optional<Field> findField(Class<?> clazz, String name) {
        return this.findField(clazz, name, null);
    }

    default public Optional<Field> findField(Class<?> clazz, String name, Class<?> type) {
        for (Class<?> searchType = clazz; !Object.class.equals(searchType) && searchType != null; searchType = searchType.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = searchType.getDeclaredFields()) {
                if (name != null && !name.equals(field.getName()) || type != null && !type.equals(field.getType())) continue;
                return Optional.of(field);
            }
        }
        return Optional.empty();
    }

    default public String[] getPossibleMethodNames(String name) {
        if (name == null || name.length() < 1) {
            return new String[0];
        }
        Object baseName = name.length() == 1 ? name.toUpperCase() : name.substring(0, 1).toUpperCase() + name.substring(1);
        String[] names = new String[]{name, "get" + (String)baseName, "is" + (String)baseName};
        return names;
    }

    default public Optional<Method> findMethod(Class<?> clazz, String name) {
        return Arrays.stream(this.getPossibleMethodNames(name)).map(methodName -> this.findMethod(clazz, (String)methodName, new Class[0]).orElse(null)).filter(Objects::nonNull).findFirst();
    }

    default public Optional<Method> findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : searchType.getDeclaredMethods()) {
                if (!name.equals(method.getName()) || paramTypes != null && !Arrays.equals(paramTypes, method.getParameterTypes())) continue;
                return Optional.of(method);
            }
        }
        return Optional.empty();
    }

    default public Object invoke(Method method, Object obj) {
        try {
            if (!method.canAccess(obj)) {
                method.setAccessible(true);
            }
            return method.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new ValueExtractorException("Invoking method '" + method.getName() + "' failed.", e);
        }
    }

    default public Object invoke(Field field, Object obj) {
        if (!field.canAccess(obj)) {
            field.setAccessible(true);
        }
        try {
            return field.get(obj);
        }
        catch (IllegalAccessException e) {
            throw new ValueExtractorException("Getting value from add '" + field.getName() + "' failed", e);
        }
    }
}

