/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.bremersee.comparator.ComparatorBuilder;
import org.bremersee.comparator.model.ComparatorField;

public interface WellKnownTextParser {
    default public Comparator<Object> parse(String wkt) {
        ComparatorBuilder builder = ComparatorBuilder.builder();
        for (ComparatorField comparatorField : this.buildComparatorFields(wkt)) {
            Comparator comparator = this.apply(comparatorField);
            if (comparator == null) continue;
            builder.add(comparator);
        }
        return builder.build();
    }

    default public List<ComparatorField> buildComparatorFields(String wkt) {
        ArrayList<ComparatorField> fields = new ArrayList<ComparatorField>();
        for (String fieldDescription : wkt.split(Pattern.quote("|"))) {
            fields.add(this.buildComparatorField(fieldDescription));
        }
        return fields;
    }

    default public ComparatorField buildComparatorField(String fieldDescription) {
        if (fieldDescription == null || fieldDescription.trim().length() == 0) {
            return new ComparatorField(null, true, true, false);
        }
        if (fieldDescription.contains("|")) {
            throw new IllegalArgumentException("The field description [" + fieldDescription + "] contains more than one field description. Use 'buildComparatorFields' instead.");
        }
        return new ComparatorField(WellKnownTextParser.findStringPart(fieldDescription, ",", 0), WellKnownTextParser.findBooleanPart(fieldDescription, ",", 1, true, "asc", "true", "1"), WellKnownTextParser.findBooleanPart(fieldDescription, ",", 2, true, "ignoreCase", "true", "1"), WellKnownTextParser.findBooleanPart(fieldDescription, ",", 3, false, "nullIsFirst", "true", "1"));
    }

    public Comparator apply(ComparatorField var1);

    public static String findStringPart(String fieldDescription, String delimiter, int index) {
        if (delimiter == null || delimiter.length() == 0 || fieldDescription == null) {
            return fieldDescription;
        }
        String[] parts = fieldDescription.split(Pattern.quote(delimiter));
        if (parts.length > index) {
            return parts[index].trim();
        }
        return null;
    }

    public static boolean findBooleanPart(String fieldDescription, String delimiter, int index, boolean defaultValue, String ... expectedValues) {
        String part = WellKnownTextParser.findStringPart(fieldDescription, delimiter, index);
        if (part != null && part.length() > 0 && expectedValues != null) {
            return Arrays.stream(expectedValues).anyMatch(part::equalsIgnoreCase);
        }
        return defaultValue;
    }
}

