/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator;

import java.util.Comparator;
import org.bremersee.comparator.DefaultValueExtractor;
import org.bremersee.comparator.ValueExtractor;

public class DelegatingComparator
implements Comparator<Object> {
    private final ValueExtractor valueExtractor;
    private final String field;
    private final Comparator comparator;

    public DelegatingComparator(String field, Comparator<?> comparator) {
        this(field, null, comparator);
    }

    public DelegatingComparator(String field, ValueExtractor valueExtractor, Comparator<?> comparator) {
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator must not be null.");
        }
        this.field = field;
        this.comparator = comparator;
        this.valueExtractor = valueExtractor != null ? valueExtractor : new DefaultValueExtractor();
    }

    @Override
    public int compare(Object o1, Object o2) {
        Object v1 = this.valueExtractor.findValue(o1, this.field);
        Object v2 = this.valueExtractor.findValue(o2, this.field);
        return this.comparator.compare(v1, v2);
    }

    public String toString() {
        return "DelegatingComparator(valueExtractor=" + this.valueExtractor + ", field=" + this.field + ", comparator=" + this.comparator + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DelegatingComparator)) {
            return false;
        }
        DelegatingComparator other = (DelegatingComparator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ValueExtractor this$valueExtractor = this.valueExtractor;
        ValueExtractor other$valueExtractor = other.valueExtractor;
        if (this$valueExtractor == null ? other$valueExtractor != null : !this$valueExtractor.equals(other$valueExtractor)) {
            return false;
        }
        String this$field = this.field;
        String other$field = other.field;
        if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
            return false;
        }
        Comparator this$comparator = this.comparator;
        Comparator other$comparator = other.comparator;
        return !(this$comparator == null ? other$comparator != null : !((Object)this$comparator).equals(other$comparator));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DelegatingComparator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ValueExtractor $valueExtractor = this.valueExtractor;
        result = result * 59 + ($valueExtractor == null ? 43 : $valueExtractor.hashCode());
        String $field = this.field;
        result = result * 59 + ($field == null ? 43 : $field.hashCode());
        Comparator $comparator = this.comparator;
        result = result * 59 + ($comparator == null ? 43 : $comparator.hashCode());
        return result;
    }
}

