/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.bremersee.comparator.model.ComparatorField;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="comparatorFields")
@XmlType(name="comparatorFieldsType")
@JsonIgnoreProperties(ignoreUnknown=true)
@ApiModel(value="ComparatorFields", description="A list of comparator fields.")
public class ComparatorFields {
    private List<ComparatorField> fields = new ArrayList<ComparatorField>();

    public ComparatorFields() {
    }

    @JsonCreator
    public ComparatorFields(@JsonProperty(value="fields") Collection<? extends ComparatorField> fields) {
        if (fields != null) {
            this.fields.addAll(fields);
        }
    }

    public List<ComparatorField> getFields() {
        return this.fields;
    }

    public String toWkt() {
        return this.fields.stream().map(ComparatorField::toWkt).collect(Collectors.joining("|"));
    }

    public String toString() {
        return this.toWkt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComparatorFields)) {
            return false;
        }
        ComparatorFields fields1 = (ComparatorFields)o;
        return Objects.equals(this.fields, fields1.fields);
    }

    public int hashCode() {
        return Objects.hash(this.fields);
    }
}

