/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModel;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlRootElement(name="comparatorField")
@XmlType(name="comparatorFieldType", propOrder={"field", "asc", "ignoreCase", "nullIsFirst"})
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"field", "asc", "ignoreCase", "nullIsFirst"})
@ApiModel(value="ComparatorField", description="A comparator field defines how a field of an object is sorted.")
public class ComparatorField {
    @XmlElement(name="field")
    private String field;
    @XmlElement(name="asc", defaultValue="true")
    private boolean asc = true;
    @XmlElement(name="ignoreCase", defaultValue="true")
    private boolean ignoreCase = true;
    @XmlElement(name="nullIsFirst", defaultValue="false")
    private boolean nullIsFirst = false;

    public ComparatorField() {
        this(null, true, true, false);
    }

    @JsonCreator
    public ComparatorField(@JsonProperty(value="field") String field, @JsonProperty(value="asc", defaultValue="true") boolean asc, @JsonProperty(value="ignoreCase", defaultValue="true") boolean ignoreCase, @JsonProperty(value="nullIsFirst", defaultValue="false") boolean nullIsFirst) {
        this.field = field;
        this.asc = asc;
        this.ignoreCase = ignoreCase;
        this.nullIsFirst = nullIsFirst;
    }

    public String getField() {
        return this.field;
    }

    public boolean isAsc() {
        return this.asc;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public boolean isNullIsFirst() {
        return this.nullIsFirst;
    }

    public String toWkt() {
        return (this.field != null ? this.field : "") + "," + (this.asc ? "asc," : "desc,") + this.ignoreCase + "," + this.nullIsFirst;
    }

    public String toString() {
        return this.toWkt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ComparatorField)) {
            return false;
        }
        ComparatorField that = (ComparatorField)o;
        return this.asc == that.asc && this.ignoreCase == that.ignoreCase && this.nullIsFirst == that.nullIsFirst && Objects.equals(this.field, that.field);
    }

    public int hashCode() {
        return Objects.hash(this.field, this.asc, this.ignoreCase, this.nullIsFirst);
    }
}

