/*
 * Decompiled with CFR 0.152.
 */
package org.bremersee.comparator;

import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.bremersee.comparator.ComparatorChain;
import org.bremersee.comparator.DelegatingComparator;
import org.bremersee.comparator.ValueComparator;
import org.bremersee.comparator.ValueExtractor;
import org.bremersee.comparator.WellKnownTextParser;
import org.bremersee.comparator.model.ComparatorField;

public interface ComparatorBuilder {
    public static ComparatorBuilder builder() {
        return new DefaultComparatorBuilder();
    }

    default public ComparatorBuilder add(Comparator<?> comparator) {
        return this.add(null, null, comparator);
    }

    default public ComparatorBuilder add(String field, Comparator<?> comparator) {
        return this.add(field, null, comparator);
    }

    public ComparatorBuilder add(String var1, ValueExtractor var2, Comparator<?> var3);

    default public ComparatorBuilder add(String field, boolean asc, boolean ignoreCase, boolean nullIsFirst) {
        return this.add(field, asc, ignoreCase, nullIsFirst, null);
    }

    public ComparatorBuilder add(String var1, boolean var2, boolean var3, boolean var4, ValueExtractor var5);

    default public ComparatorBuilder add(ComparatorField field) {
        return this.add(field, null);
    }

    default public ComparatorBuilder add(ComparatorField field, ValueExtractor valueExtractor) {
        if (field == null) {
            throw new IllegalArgumentException("Field must not be null.");
        }
        return this.add(field.getField(), field.isAsc(), field.isIgnoreCase(), field.isNullIsFirst(), valueExtractor);
    }

    default public ComparatorBuilder addAll(Collection<? extends ComparatorField> fields) {
        return this.addAll(fields, null);
    }

    default public ComparatorBuilder addAll(Collection<? extends ComparatorField> fields, ValueExtractor valueExtractor) {
        if (fields != null) {
            for (ComparatorField comparatorField : fields) {
                this.add(comparatorField, valueExtractor);
            }
        }
        return this;
    }

    default public ComparatorBuilder fromWellKnownText(String wkt) {
        return this.fromWellKnownText(wkt, null);
    }

    public ComparatorBuilder fromWellKnownText(String var1, WellKnownTextParser var2);

    public Comparator<Object> build();

    public static class DefaultComparatorBuilder
    implements ComparatorBuilder {
        private final List<Comparator> comparatorChain = new LinkedList<Comparator>();

        @Override
        public ComparatorBuilder add(String field, ValueExtractor valueExtractor, Comparator<?> comparator) {
            if (comparator != null) {
                this.comparatorChain.add(new DelegatingComparator(field, valueExtractor, comparator));
            }
            return this;
        }

        @Override
        public ComparatorBuilder add(String field, boolean asc, boolean ignoreCase, boolean nullIsFirst, ValueExtractor valueExtractor) {
            this.comparatorChain.add(new ValueComparator(field, asc, ignoreCase, nullIsFirst, valueExtractor));
            return this;
        }

        @Override
        public ComparatorBuilder fromWellKnownText(String wkt, WellKnownTextParser wktParser) {
            if (wktParser != null) {
                this.comparatorChain.add(wktParser.parse(wkt));
            } else {
                WellKnownTextParser parser = ValueComparator::new;
                this.comparatorChain.add(parser.parse(wkt));
            }
            return this;
        }

        @Override
        public Comparator<Object> build() {
            return new ComparatorChain(this.comparatorChain);
        }
    }
}

